<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractPermissionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Abstract Permission.
 * @subpackage Structs
 */
class AbstractPermissionStructure extends AbstractStructBase
{
    /**
     * The AllParticipants
     * Meta informations extracted from the WSDL
     * - documentation: Parmissions apply by default to All particpants. May be overidden by other separate permissions for individual.
     * @var string
     */
    public $AllParticipants;
    /**
     * The ParticipantRef
     * Meta informations extracted from the WSDL
     * - documentation: Permission applies to specified participant.
     * @var \StructType\ParticipantRefStructure
     */
    public $ParticipantRef;
    /**
     * The GeneralCapabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GeneralCapabilities
     */
    public $GeneralCapabilities;
    /**
     * Constructor method for AbstractPermissionStructure
     * @uses AbstractPermissionStructure::setAllParticipants()
     * @uses AbstractPermissionStructure::setParticipantRef()
     * @uses AbstractPermissionStructure::setGeneralCapabilities()
     * @param string $allParticipants
     * @param \StructType\ParticipantRefStructure $participantRef
     * @param \StructType\GeneralCapabilities $generalCapabilities
     */
    public function __construct($allParticipants = null, \StructType\ParticipantRefStructure $participantRef = null, \StructType\GeneralCapabilities $generalCapabilities = null)
    {
        $this
            ->setAllParticipants($allParticipants)
            ->setParticipantRef($participantRef)
            ->setGeneralCapabilities($generalCapabilities);
    }
    /**
     * Get AllParticipants value
     * @return string|null
     */
    public function getAllParticipants()
    {
        return $this->AllParticipants;
    }
    /**
     * Set AllParticipants value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allParticipants
     * @return \StructType\AbstractPermissionStructure
     */
    public function setAllParticipants($allParticipants = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($allParticipants)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allParticipants, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->AllParticipants = $allParticipants;
        return $this;
    }
    /**
     * Get ParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getParticipantRef()
    {
        return $this->ParticipantRef;
    }
    /**
     * Set ParticipantRef value
     * @param \StructType\ParticipantRefStructure $participantRef
     * @return \StructType\AbstractPermissionStructure
     */
    public function setParticipantRef(\StructType\ParticipantRefStructure $participantRef = null)
    {
        $this->ParticipantRef = $participantRef;
        return $this;
    }
    /**
     * Get GeneralCapabilities value
     * @return \StructType\GeneralCapabilities|null
     */
    public function getGeneralCapabilities()
    {
        return $this->GeneralCapabilities;
    }
    /**
     * Set GeneralCapabilities value
     * @param \StructType\GeneralCapabilities $generalCapabilities
     * @return \StructType\AbstractPermissionStructure
     */
    public function setGeneralCapabilities(\StructType\GeneralCapabilities $generalCapabilities = null)
    {
        $this->GeneralCapabilities = $generalCapabilities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractPermissionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
