<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractIdentifiedItemStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for an Activity that can be referenced.
 * @subpackage Structs
 */
abstract class AbstractIdentifiedItemStructure extends AbstractItemStructure
{
    /**
     * The ItemIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of item. | Type for identifier of an Item. A transient reference for efficient handling of events.
     * - minOccurs: 0
     * @var string
     */
    public $ItemIdentifier;
    /**
     * Constructor method for AbstractIdentifiedItemStructure
     * @uses AbstractIdentifiedItemStructure::setItemIdentifier()
     * @param string $itemIdentifier
     */
    public function __construct($itemIdentifier = null)
    {
        $this
            ->setItemIdentifier($itemIdentifier);
    }
    /**
     * Get ItemIdentifier value
     * @return string|null
     */
    public function getItemIdentifier()
    {
        return $this->ItemIdentifier;
    }
    /**
     * Set ItemIdentifier value
     * @param string $itemIdentifier
     * @return \StructType\AbstractIdentifiedItemStructure
     */
    public function setItemIdentifier($itemIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($itemIdentifier) && !is_string($itemIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemIdentifier)), __LINE__);
        }
        $this->ItemIdentifier = $itemIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractIdentifiedItemStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
