<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbnormalTraffic StructType
 * @subpackage Structs
 */
class AbnormalTraffic extends TrafficElement
{
    /**
     * The abnormalTrafficType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $abnormalTrafficType;
    /**
     * The numberOfVehiclesWaiting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfVehiclesWaiting;
    /**
     * The queueLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $queueLength;
    /**
     * The relativeTrafficFlow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $relativeTrafficFlow;
    /**
     * The trafficFlowCharacteristics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficFlowCharacteristics;
    /**
     * The trafficTrendType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficTrendType;
    /**
     * The abnormalTrafficExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $abnormalTrafficExtension;
    /**
     * Constructor method for AbnormalTraffic
     * @uses AbnormalTraffic::setAbnormalTrafficType()
     * @uses AbnormalTraffic::setNumberOfVehiclesWaiting()
     * @uses AbnormalTraffic::setQueueLength()
     * @uses AbnormalTraffic::setRelativeTrafficFlow()
     * @uses AbnormalTraffic::setTrafficFlowCharacteristics()
     * @uses AbnormalTraffic::setTrafficTrendType()
     * @uses AbnormalTraffic::setAbnormalTrafficExtension()
     * @param string $abnormalTrafficType
     * @param int $numberOfVehiclesWaiting
     * @param int $queueLength
     * @param string $relativeTrafficFlow
     * @param string $trafficFlowCharacteristics
     * @param string $trafficTrendType
     * @param \StructType\ExtensionType $abnormalTrafficExtension
     */
    public function __construct($abnormalTrafficType = null, $numberOfVehiclesWaiting = null, $queueLength = null, $relativeTrafficFlow = null, $trafficFlowCharacteristics = null, $trafficTrendType = null, \StructType\ExtensionType $abnormalTrafficExtension = null)
    {
        $this
            ->setAbnormalTrafficType($abnormalTrafficType)
            ->setNumberOfVehiclesWaiting($numberOfVehiclesWaiting)
            ->setQueueLength($queueLength)
            ->setRelativeTrafficFlow($relativeTrafficFlow)
            ->setTrafficFlowCharacteristics($trafficFlowCharacteristics)
            ->setTrafficTrendType($trafficTrendType)
            ->setAbnormalTrafficExtension($abnormalTrafficExtension);
    }
    /**
     * Get abnormalTrafficType value
     * @return string|null
     */
    public function getAbnormalTrafficType()
    {
        return $this->abnormalTrafficType;
    }
    /**
     * Set abnormalTrafficType value
     * @uses \EnumType\AbnormalTrafficTypeEnum::valueIsValid()
     * @uses \EnumType\AbnormalTrafficTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abnormalTrafficType
     * @return \StructType\AbnormalTraffic
     */
    public function setAbnormalTrafficType($abnormalTrafficType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AbnormalTrafficTypeEnum::valueIsValid($abnormalTrafficType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $abnormalTrafficType, implode(', ', \EnumType\AbnormalTrafficTypeEnum::getValidValues())), __LINE__);
        }
        $this->abnormalTrafficType = $abnormalTrafficType;
        return $this;
    }
    /**
     * Get numberOfVehiclesWaiting value
     * @return int|null
     */
    public function getNumberOfVehiclesWaiting()
    {
        return $this->numberOfVehiclesWaiting;
    }
    /**
     * Set numberOfVehiclesWaiting value
     * @param int $numberOfVehiclesWaiting
     * @return \StructType\AbnormalTraffic
     */
    public function setNumberOfVehiclesWaiting($numberOfVehiclesWaiting = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfVehiclesWaiting) && !is_numeric($numberOfVehiclesWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfVehiclesWaiting)), __LINE__);
        }
        $this->numberOfVehiclesWaiting = $numberOfVehiclesWaiting;
        return $this;
    }
    /**
     * Get queueLength value
     * @return int|null
     */
    public function getQueueLength()
    {
        return $this->queueLength;
    }
    /**
     * Set queueLength value
     * @param int $queueLength
     * @return \StructType\AbnormalTraffic
     */
    public function setQueueLength($queueLength = null)
    {
        // validation for constraint: int
        if (!is_null($queueLength) && !is_numeric($queueLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queueLength)), __LINE__);
        }
        $this->queueLength = $queueLength;
        return $this;
    }
    /**
     * Get relativeTrafficFlow value
     * @return string|null
     */
    public function getRelativeTrafficFlow()
    {
        return $this->relativeTrafficFlow;
    }
    /**
     * Set relativeTrafficFlow value
     * @uses \EnumType\RelativeTrafficFlowEnum::valueIsValid()
     * @uses \EnumType\RelativeTrafficFlowEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relativeTrafficFlow
     * @return \StructType\AbnormalTraffic
     */
    public function setRelativeTrafficFlow($relativeTrafficFlow = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RelativeTrafficFlowEnum::valueIsValid($relativeTrafficFlow)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $relativeTrafficFlow, implode(', ', \EnumType\RelativeTrafficFlowEnum::getValidValues())), __LINE__);
        }
        $this->relativeTrafficFlow = $relativeTrafficFlow;
        return $this;
    }
    /**
     * Get trafficFlowCharacteristics value
     * @return string|null
     */
    public function getTrafficFlowCharacteristics()
    {
        return $this->trafficFlowCharacteristics;
    }
    /**
     * Set trafficFlowCharacteristics value
     * @uses \EnumType\TrafficFlowCharacteristicsEnum::valueIsValid()
     * @uses \EnumType\TrafficFlowCharacteristicsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficFlowCharacteristics
     * @return \StructType\AbnormalTraffic
     */
    public function setTrafficFlowCharacteristics($trafficFlowCharacteristics = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficFlowCharacteristicsEnum::valueIsValid($trafficFlowCharacteristics)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficFlowCharacteristics, implode(', ', \EnumType\TrafficFlowCharacteristicsEnum::getValidValues())), __LINE__);
        }
        $this->trafficFlowCharacteristics = $trafficFlowCharacteristics;
        return $this;
    }
    /**
     * Get trafficTrendType value
     * @return string|null
     */
    public function getTrafficTrendType()
    {
        return $this->trafficTrendType;
    }
    /**
     * Set trafficTrendType value
     * @uses \EnumType\TrafficTrendTypeEnum::valueIsValid()
     * @uses \EnumType\TrafficTrendTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficTrendType
     * @return \StructType\AbnormalTraffic
     */
    public function setTrafficTrendType($trafficTrendType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficTrendTypeEnum::valueIsValid($trafficTrendType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficTrendType, implode(', ', \EnumType\TrafficTrendTypeEnum::getValidValues())), __LINE__);
        }
        $this->trafficTrendType = $trafficTrendType;
        return $this;
    }
    /**
     * Get abnormalTrafficExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAbnormalTrafficExtension()
    {
        return $this->abnormalTrafficExtension;
    }
    /**
     * Set abnormalTrafficExtension value
     * @param \StructType\ExtensionType $abnormalTrafficExtension
     * @return \StructType\AbnormalTraffic
     */
    public function setAbnormalTrafficExtension(\StructType\ExtensionType $abnormalTrafficExtension = null)
    {
        $this->abnormalTrafficExtension = $abnormalTrafficExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbnormalTraffic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
