<?php

namespace EnumType;

/**
 * This class stands for WorkflowStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Entry Status.
 * @subpackage Enumerations
 */
class WorkflowStatusEnumeration
{
    /**
     * Constant for value 'draft'
     * @return string 'draft'
     */
    const VALUE_DRAFT = 'draft';
    /**
     * Constant for value 'approvedDraft'
     * @return string 'approvedDraft'
     */
    const VALUE_APPROVED_DRAFT = 'approvedDraft';
    /**
     * Constant for value 'open'
     * @return string 'open'
     */
    const VALUE_OPEN = 'open';
    /**
     * Constant for value 'published'
     * @return string 'published'
     */
    const VALUE_PUBLISHED = 'published';
    /**
     * Constant for value 'closing'
     * @return string 'closing'
     */
    const VALUE_CLOSING = 'closing';
    /**
     * Constant for value 'closed'
     * @return string 'closed'
     */
    const VALUE_CLOSED = 'closed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_APPROVED_DRAFT
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_PUBLISHED
     * @uses self::VALUE_CLOSING
     * @uses self::VALUE_CLOSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRAFT,
            self::VALUE_APPROVED_DRAFT,
            self::VALUE_OPEN,
            self::VALUE_PUBLISHED,
            self::VALUE_CLOSING,
            self::VALUE_CLOSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
