<?php

namespace EnumType;

/**
 * This class stands for WeekOfMonthEnum EnumType
 * @subpackage Enumerations
 */
class WeekOfMonthEnum
{
    /**
     * Constant for value 'firstWeekOfMonth'
     * @return string 'firstWeekOfMonth'
     */
    const VALUE_FIRST_WEEK_OF_MONTH = 'firstWeekOfMonth';
    /**
     * Constant for value 'secondWeekOfMonth'
     * @return string 'secondWeekOfMonth'
     */
    const VALUE_SECOND_WEEK_OF_MONTH = 'secondWeekOfMonth';
    /**
     * Constant for value 'thirdWeekOfMonth'
     * @return string 'thirdWeekOfMonth'
     */
    const VALUE_THIRD_WEEK_OF_MONTH = 'thirdWeekOfMonth';
    /**
     * Constant for value 'fourthWeekOfMonth'
     * @return string 'fourthWeekOfMonth'
     */
    const VALUE_FOURTH_WEEK_OF_MONTH = 'fourthWeekOfMonth';
    /**
     * Constant for value 'fifthWeekOfMonth'
     * @return string 'fifthWeekOfMonth'
     */
    const VALUE_FIFTH_WEEK_OF_MONTH = 'fifthWeekOfMonth';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST_WEEK_OF_MONTH
     * @uses self::VALUE_SECOND_WEEK_OF_MONTH
     * @uses self::VALUE_THIRD_WEEK_OF_MONTH
     * @uses self::VALUE_FOURTH_WEEK_OF_MONTH
     * @uses self::VALUE_FIFTH_WEEK_OF_MONTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST_WEEK_OF_MONTH,
            self::VALUE_SECOND_WEEK_OF_MONTH,
            self::VALUE_THIRD_WEEK_OF_MONTH,
            self::VALUE_FOURTH_WEEK_OF_MONTH,
            self::VALUE_FIFTH_WEEK_OF_MONTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
