<?php

namespace EnumType;

/**
 * This class stands for VmsFaultEnum EnumType
 * @subpackage Enumerations
 */
class VmsFaultEnum
{
    /**
     * Constant for value 'communicationsFailure'
     * @return string 'communicationsFailure'
     */
    const VALUE_COMMUNICATIONS_FAILURE = 'communicationsFailure';
    /**
     * Constant for value 'incorrectMessageDisplayed'
     * @return string 'incorrectMessageDisplayed'
     */
    const VALUE_INCORRECT_MESSAGE_DISPLAYED = 'incorrectMessageDisplayed';
    /**
     * Constant for value 'incorrectPictogramDisplayed'
     * @return string 'incorrectPictogramDisplayed'
     */
    const VALUE_INCORRECT_PICTOGRAM_DISPLAYED = 'incorrectPictogramDisplayed';
    /**
     * Constant for value 'outOfService'
     * @return string 'outOfService'
     */
    const VALUE_OUT_OF_SERVICE = 'outOfService';
    /**
     * Constant for value 'powerFailure'
     * @return string 'powerFailure'
     */
    const VALUE_POWER_FAILURE = 'powerFailure';
    /**
     * Constant for value 'unableToClearDown'
     * @return string 'unableToClearDown'
     */
    const VALUE_UNABLE_TO_CLEAR_DOWN = 'unableToClearDown';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMUNICATIONS_FAILURE
     * @uses self::VALUE_INCORRECT_MESSAGE_DISPLAYED
     * @uses self::VALUE_INCORRECT_PICTOGRAM_DISPLAYED
     * @uses self::VALUE_OUT_OF_SERVICE
     * @uses self::VALUE_POWER_FAILURE
     * @uses self::VALUE_UNABLE_TO_CLEAR_DOWN
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMUNICATIONS_FAILURE,
            self::VALUE_INCORRECT_MESSAGE_DISPLAYED,
            self::VALUE_INCORRECT_PICTOGRAM_DISPLAYED,
            self::VALUE_OUT_OF_SERVICE,
            self::VALUE_POWER_FAILURE,
            self::VALUE_UNABLE_TO_CLEAR_DOWN,
            self::VALUE_UNKNOWN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
