<?php

namespace EnumType;

/**
 * This class stands for VerificationStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Verification Status Corresponds to TPEG pti_table 32.
 * @subpackage Enumerations
 */
class VerificationStatusEnumeration
{
    /**
     * Constant for value 'pti32_0'
     * @return string 'pti32_0'
     */
    const VALUE_PTI_32_0 = 'pti32_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti32_1'
     * @return string 'pti32_1'
     */
    const VALUE_PTI_32_1 = 'pti32_1';
    /**
     * Constant for value 'unverified'
     * @return string 'unverified'
     */
    const VALUE_UNVERIFIED = 'unverified';
    /**
     * Constant for value 'pti32_255'
     * @return string 'pti32_255'
     */
    const VALUE_PTI_32_255 = 'pti32_255';
    /**
     * Constant for value 'verified'
     * @return string 'verified'
     */
    const VALUE_VERIFIED = 'verified';
    /**
     * Constant for value 'verifiedAsDuplicate'
     * @return string 'verifiedAsDuplicate'
     */
    const VALUE_VERIFIED_AS_DUPLICATE = 'verifiedAsDuplicate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_32_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_32_1
     * @uses self::VALUE_UNVERIFIED
     * @uses self::VALUE_PTI_32_255
     * @uses self::VALUE_VERIFIED
     * @uses self::VALUE_VERIFIED_AS_DUPLICATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_32_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_32_1,
            self::VALUE_UNVERIFIED,
            self::VALUE_PTI_32_255,
            self::VALUE_VERIFIED,
            self::VALUE_VERIFIED_AS_DUPLICATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
