<?php

namespace EnumType;

/**
 * This class stands for VehicleStatusEnum EnumType
 * @subpackage Enumerations
 */
class VehicleStatusEnum
{
    /**
     * Constant for value 'abandoned'
     * @return string 'abandoned'
     */
    const VALUE_ABANDONED = 'abandoned';
    /**
     * Constant for value 'brokenDown'
     * @return string 'brokenDown'
     */
    const VALUE_BROKEN_DOWN = 'brokenDown';
    /**
     * Constant for value 'burntOut'
     * @return string 'burntOut'
     */
    const VALUE_BURNT_OUT = 'burntOut';
    /**
     * Constant for value 'damaged'
     * @return string 'damaged'
     */
    const VALUE_DAMAGED = 'damaged';
    /**
     * Constant for value 'damagedAndImmobilized'
     * @return string 'damagedAndImmobilized'
     */
    const VALUE_DAMAGED_AND_IMMOBILIZED = 'damagedAndImmobilized';
    /**
     * Constant for value 'onFire'
     * @return string 'onFire'
     */
    const VALUE_ON_FIRE = 'onFire';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ABANDONED
     * @uses self::VALUE_BROKEN_DOWN
     * @uses self::VALUE_BURNT_OUT
     * @uses self::VALUE_DAMAGED
     * @uses self::VALUE_DAMAGED_AND_IMMOBILIZED
     * @uses self::VALUE_ON_FIRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ABANDONED,
            self::VALUE_BROKEN_DOWN,
            self::VALUE_BURNT_OUT,
            self::VALUE_DAMAGED,
            self::VALUE_DAMAGED_AND_IMMOBILIZED,
            self::VALUE_ON_FIRE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
