<?php

namespace EnumType;

/**
 * This class stands for UpdateMethodEnum EnumType
 * @subpackage Enumerations
 */
class UpdateMethodEnum
{
    /**
     * Constant for value 'allElementUpdate'
     * @return string 'allElementUpdate'
     */
    const VALUE_ALL_ELEMENT_UPDATE = 'allElementUpdate';
    /**
     * Constant for value 'singleElementUpdate'
     * @return string 'singleElementUpdate'
     */
    const VALUE_SINGLE_ELEMENT_UPDATE = 'singleElementUpdate';
    /**
     * Constant for value 'snapshot'
     * @return string 'snapshot'
     */
    const VALUE_SNAPSHOT = 'snapshot';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_ELEMENT_UPDATE
     * @uses self::VALUE_SINGLE_ELEMENT_UPDATE
     * @uses self::VALUE_SNAPSHOT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_ELEMENT_UPDATE,
            self::VALUE_SINGLE_ELEMENT_UPDATE,
            self::VALUE_SNAPSHOT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
