<?php

namespace EnumType;

/**
 * This class stands for TravelTimeTypeEnum EnumType
 * @subpackage Enumerations
 */
class TravelTimeTypeEnum
{
    /**
     * Constant for value 'best'
     * @return string 'best'
     */
    const VALUE_BEST = 'best';
    /**
     * Constant for value 'estimated'
     * @return string 'estimated'
     */
    const VALUE_ESTIMATED = 'estimated';
    /**
     * Constant for value 'instantaneous'
     * @return string 'instantaneous'
     */
    const VALUE_INSTANTANEOUS = 'instantaneous';
    /**
     * Constant for value 'reconstituted'
     * @return string 'reconstituted'
     */
    const VALUE_RECONSTITUTED = 'reconstituted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEST
     * @uses self::VALUE_ESTIMATED
     * @uses self::VALUE_INSTANTANEOUS
     * @uses self::VALUE_RECONSTITUTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEST,
            self::VALUE_ESTIMATED,
            self::VALUE_INSTANTANEOUS,
            self::VALUE_RECONSTITUTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
