<?php

namespace EnumType;

/**
 * This class stands for TransitServiceTypeEnum EnumType
 * @subpackage Enumerations
 */
class TransitServiceTypeEnum
{
    /**
     * Constant for value 'air'
     * @return string 'air'
     */
    const VALUE_AIR = 'air';
    /**
     * Constant for value 'bus'
     * @return string 'bus'
     */
    const VALUE_BUS = 'bus';
    /**
     * Constant for value 'ferry'
     * @return string 'ferry'
     */
    const VALUE_FERRY = 'ferry';
    /**
     * Constant for value 'hydrofoil'
     * @return string 'hydrofoil'
     */
    const VALUE_HYDROFOIL = 'hydrofoil';
    /**
     * Constant for value 'rail'
     * @return string 'rail'
     */
    const VALUE_RAIL = 'rail';
    /**
     * Constant for value 'tram'
     * @return string 'tram'
     */
    const VALUE_TRAM = 'tram';
    /**
     * Constant for value 'undergroundMetro'
     * @return string 'undergroundMetro'
     */
    const VALUE_UNDERGROUND_METRO = 'undergroundMetro';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIR
     * @uses self::VALUE_BUS
     * @uses self::VALUE_FERRY
     * @uses self::VALUE_HYDROFOIL
     * @uses self::VALUE_RAIL
     * @uses self::VALUE_TRAM
     * @uses self::VALUE_UNDERGROUND_METRO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIR,
            self::VALUE_BUS,
            self::VALUE_FERRY,
            self::VALUE_HYDROFOIL,
            self::VALUE_RAIL,
            self::VALUE_TRAM,
            self::VALUE_UNDERGROUND_METRO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
