<?php

namespace EnumType;

/**
 * This class stands for TrafficConstrictionTypeEnum EnumType
 * @subpackage Enumerations
 */
class TrafficConstrictionTypeEnum
{
    /**
     * Constant for value 'carriagewayBlocked'
     * @return string 'carriagewayBlocked'
     */
    const VALUE_CARRIAGEWAY_BLOCKED = 'carriagewayBlocked';
    /**
     * Constant for value 'carriagewayPartiallyObstructed'
     * @return string 'carriagewayPartiallyObstructed'
     */
    const VALUE_CARRIAGEWAY_PARTIALLY_OBSTRUCTED = 'carriagewayPartiallyObstructed';
    /**
     * Constant for value 'lanesBlocked'
     * @return string 'lanesBlocked'
     */
    const VALUE_LANES_BLOCKED = 'lanesBlocked';
    /**
     * Constant for value 'lanesPartiallyObstructed'
     * @return string 'lanesPartiallyObstructed'
     */
    const VALUE_LANES_PARTIALLY_OBSTRUCTED = 'lanesPartiallyObstructed';
    /**
     * Constant for value 'roadBlocked'
     * @return string 'roadBlocked'
     */
    const VALUE_ROAD_BLOCKED = 'roadBlocked';
    /**
     * Constant for value 'roadPartiallyObstructed'
     * @return string 'roadPartiallyObstructed'
     */
    const VALUE_ROAD_PARTIALLY_OBSTRUCTED = 'roadPartiallyObstructed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CARRIAGEWAY_BLOCKED
     * @uses self::VALUE_CARRIAGEWAY_PARTIALLY_OBSTRUCTED
     * @uses self::VALUE_LANES_BLOCKED
     * @uses self::VALUE_LANES_PARTIALLY_OBSTRUCTED
     * @uses self::VALUE_ROAD_BLOCKED
     * @uses self::VALUE_ROAD_PARTIALLY_OBSTRUCTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CARRIAGEWAY_BLOCKED,
            self::VALUE_CARRIAGEWAY_PARTIALLY_OBSTRUCTED,
            self::VALUE_LANES_BLOCKED,
            self::VALUE_LANES_PARTIALLY_OBSTRUCTED,
            self::VALUE_ROAD_BLOCKED,
            self::VALUE_ROAD_PARTIALLY_OBSTRUCTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
