<?php

namespace EnumType;

/**
 * This class stands for TpegLoc04HeightTypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc04HeightTypeEnum
{
    /**
     * Constant for value 'above'
     * @return string 'above'
     */
    const VALUE_ABOVE = 'above';
    /**
     * Constant for value 'aboveSeaLevel'
     * @return string 'aboveSeaLevel'
     */
    const VALUE_ABOVE_SEA_LEVEL = 'aboveSeaLevel';
    /**
     * Constant for value 'aboveStreetLevel'
     * @return string 'aboveStreetLevel'
     */
    const VALUE_ABOVE_STREET_LEVEL = 'aboveStreetLevel';
    /**
     * Constant for value 'at'
     * @return string 'at'
     */
    const VALUE_AT = 'at';
    /**
     * Constant for value 'atSeaLevel'
     * @return string 'atSeaLevel'
     */
    const VALUE_AT_SEA_LEVEL = 'atSeaLevel';
    /**
     * Constant for value 'atStreetLevel'
     * @return string 'atStreetLevel'
     */
    const VALUE_AT_STREET_LEVEL = 'atStreetLevel';
    /**
     * Constant for value 'below'
     * @return string 'below'
     */
    const VALUE_BELOW = 'below';
    /**
     * Constant for value 'belowSeaLevel'
     * @return string 'belowSeaLevel'
     */
    const VALUE_BELOW_SEA_LEVEL = 'belowSeaLevel';
    /**
     * Constant for value 'belowStreetLevel'
     * @return string 'belowStreetLevel'
     */
    const VALUE_BELOW_STREET_LEVEL = 'belowStreetLevel';
    /**
     * Constant for value 'undefined'
     * @return string 'undefined'
     */
    const VALUE_UNDEFINED = 'undefined';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ABOVE
     * @uses self::VALUE_ABOVE_SEA_LEVEL
     * @uses self::VALUE_ABOVE_STREET_LEVEL
     * @uses self::VALUE_AT
     * @uses self::VALUE_AT_SEA_LEVEL
     * @uses self::VALUE_AT_STREET_LEVEL
     * @uses self::VALUE_BELOW
     * @uses self::VALUE_BELOW_SEA_LEVEL
     * @uses self::VALUE_BELOW_STREET_LEVEL
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ABOVE,
            self::VALUE_ABOVE_SEA_LEVEL,
            self::VALUE_ABOVE_STREET_LEVEL,
            self::VALUE_AT,
            self::VALUE_AT_SEA_LEVEL,
            self::VALUE_AT_STREET_LEVEL,
            self::VALUE_BELOW,
            self::VALUE_BELOW_SEA_LEVEL,
            self::VALUE_BELOW_STREET_LEVEL,
            self::VALUE_UNDEFINED,
            self::VALUE_UNKNOWN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
