<?php

namespace EnumType;

/**
 * This class stands for TpegLoc03OtherPointDescriptorSubtypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc03OtherPointDescriptorSubtypeEnum
{
    /**
     * Constant for value 'administrativeAreaName'
     * @return string 'administrativeAreaName'
     */
    const VALUE_ADMINISTRATIVE_AREA_NAME = 'administrativeAreaName';
    /**
     * Constant for value 'administrativeReferenceName'
     * @return string 'administrativeReferenceName'
     */
    const VALUE_ADMINISTRATIVE_REFERENCE_NAME = 'administrativeReferenceName';
    /**
     * Constant for value 'airportName'
     * @return string 'airportName'
     */
    const VALUE_AIRPORT_NAME = 'airportName';
    /**
     * Constant for value 'areaName'
     * @return string 'areaName'
     */
    const VALUE_AREA_NAME = 'areaName';
    /**
     * Constant for value 'buildingName'
     * @return string 'buildingName'
     */
    const VALUE_BUILDING_NAME = 'buildingName';
    /**
     * Constant for value 'busStopIdentifier'
     * @return string 'busStopIdentifier'
     */
    const VALUE_BUS_STOP_IDENTIFIER = 'busStopIdentifier';
    /**
     * Constant for value 'busStopName'
     * @return string 'busStopName'
     */
    const VALUE_BUS_STOP_NAME = 'busStopName';
    /**
     * Constant for value 'canalName'
     * @return string 'canalName'
     */
    const VALUE_CANAL_NAME = 'canalName';
    /**
     * Constant for value 'countyName'
     * @return string 'countyName'
     */
    const VALUE_COUNTY_NAME = 'countyName';
    /**
     * Constant for value 'ferryPortName'
     * @return string 'ferryPortName'
     */
    const VALUE_FERRY_PORT_NAME = 'ferryPortName';
    /**
     * Constant for value 'intersectionName'
     * @return string 'intersectionName'
     */
    const VALUE_INTERSECTION_NAME = 'intersectionName';
    /**
     * Constant for value 'lakeName'
     * @return string 'lakeName'
     */
    const VALUE_LAKE_NAME = 'lakeName';
    /**
     * Constant for value 'linkName'
     * @return string 'linkName'
     */
    const VALUE_LINK_NAME = 'linkName';
    /**
     * Constant for value 'localLinkName'
     * @return string 'localLinkName'
     */
    const VALUE_LOCAL_LINK_NAME = 'localLinkName';
    /**
     * Constant for value 'metroStationName'
     * @return string 'metroStationName'
     */
    const VALUE_METRO_STATION_NAME = 'metroStationName';
    /**
     * Constant for value 'nationName'
     * @return string 'nationName'
     */
    const VALUE_NATION_NAME = 'nationName';
    /**
     * Constant for value 'nonLinkedPointName'
     * @return string 'nonLinkedPointName'
     */
    const VALUE_NON_LINKED_POINT_NAME = 'nonLinkedPointName';
    /**
     * Constant for value 'parkingFacilityName'
     * @return string 'parkingFacilityName'
     */
    const VALUE_PARKING_FACILITY_NAME = 'parkingFacilityName';
    /**
     * Constant for value 'pointName'
     * @return string 'pointName'
     */
    const VALUE_POINT_NAME = 'pointName';
    /**
     * Constant for value 'pointOfInterestName'
     * @return string 'pointOfInterestName'
     */
    const VALUE_POINT_OF_INTEREST_NAME = 'pointOfInterestName';
    /**
     * Constant for value 'railwayStation'
     * @return string 'railwayStation'
     */
    const VALUE_RAILWAY_STATION = 'railwayStation';
    /**
     * Constant for value 'regionName'
     * @return string 'regionName'
     */
    const VALUE_REGION_NAME = 'regionName';
    /**
     * Constant for value 'riverName'
     * @return string 'riverName'
     */
    const VALUE_RIVER_NAME = 'riverName';
    /**
     * Constant for value 'seaName'
     * @return string 'seaName'
     */
    const VALUE_SEA_NAME = 'seaName';
    /**
     * Constant for value 'serviceAreaName'
     * @return string 'serviceAreaName'
     */
    const VALUE_SERVICE_AREA_NAME = 'serviceAreaName';
    /**
     * Constant for value 'tidalRiverName'
     * @return string 'tidalRiverName'
     */
    const VALUE_TIDAL_RIVER_NAME = 'tidalRiverName';
    /**
     * Constant for value 'townName'
     * @return string 'townName'
     */
    const VALUE_TOWN_NAME = 'townName';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADMINISTRATIVE_AREA_NAME
     * @uses self::VALUE_ADMINISTRATIVE_REFERENCE_NAME
     * @uses self::VALUE_AIRPORT_NAME
     * @uses self::VALUE_AREA_NAME
     * @uses self::VALUE_BUILDING_NAME
     * @uses self::VALUE_BUS_STOP_IDENTIFIER
     * @uses self::VALUE_BUS_STOP_NAME
     * @uses self::VALUE_CANAL_NAME
     * @uses self::VALUE_COUNTY_NAME
     * @uses self::VALUE_FERRY_PORT_NAME
     * @uses self::VALUE_INTERSECTION_NAME
     * @uses self::VALUE_LAKE_NAME
     * @uses self::VALUE_LINK_NAME
     * @uses self::VALUE_LOCAL_LINK_NAME
     * @uses self::VALUE_METRO_STATION_NAME
     * @uses self::VALUE_NATION_NAME
     * @uses self::VALUE_NON_LINKED_POINT_NAME
     * @uses self::VALUE_PARKING_FACILITY_NAME
     * @uses self::VALUE_POINT_NAME
     * @uses self::VALUE_POINT_OF_INTEREST_NAME
     * @uses self::VALUE_RAILWAY_STATION
     * @uses self::VALUE_REGION_NAME
     * @uses self::VALUE_RIVER_NAME
     * @uses self::VALUE_SEA_NAME
     * @uses self::VALUE_SERVICE_AREA_NAME
     * @uses self::VALUE_TIDAL_RIVER_NAME
     * @uses self::VALUE_TOWN_NAME
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADMINISTRATIVE_AREA_NAME,
            self::VALUE_ADMINISTRATIVE_REFERENCE_NAME,
            self::VALUE_AIRPORT_NAME,
            self::VALUE_AREA_NAME,
            self::VALUE_BUILDING_NAME,
            self::VALUE_BUS_STOP_IDENTIFIER,
            self::VALUE_BUS_STOP_NAME,
            self::VALUE_CANAL_NAME,
            self::VALUE_COUNTY_NAME,
            self::VALUE_FERRY_PORT_NAME,
            self::VALUE_INTERSECTION_NAME,
            self::VALUE_LAKE_NAME,
            self::VALUE_LINK_NAME,
            self::VALUE_LOCAL_LINK_NAME,
            self::VALUE_METRO_STATION_NAME,
            self::VALUE_NATION_NAME,
            self::VALUE_NON_LINKED_POINT_NAME,
            self::VALUE_PARKING_FACILITY_NAME,
            self::VALUE_POINT_NAME,
            self::VALUE_POINT_OF_INTEREST_NAME,
            self::VALUE_RAILWAY_STATION,
            self::VALUE_REGION_NAME,
            self::VALUE_RIVER_NAME,
            self::VALUE_SEA_NAME,
            self::VALUE_SERVICE_AREA_NAME,
            self::VALUE_TIDAL_RIVER_NAME,
            self::VALUE_TOWN_NAME,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
