<?php

namespace EnumType;

/**
 * This class stands for TpegLoc03IlcPointDescriptorSubtypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc03IlcPointDescriptorSubtypeEnum
{
    /**
     * Constant for value 'tpegIlcName1'
     * @return string 'tpegIlcName1'
     */
    const VALUE_TPEG_ILC_NAME_1 = 'tpegIlcName1';
    /**
     * Constant for value 'tpegIlcName2'
     * @return string 'tpegIlcName2'
     */
    const VALUE_TPEG_ILC_NAME_2 = 'tpegIlcName2';
    /**
     * Constant for value 'tpegIlcName3'
     * @return string 'tpegIlcName3'
     */
    const VALUE_TPEG_ILC_NAME_3 = 'tpegIlcName3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TPEG_ILC_NAME_1
     * @uses self::VALUE_TPEG_ILC_NAME_2
     * @uses self::VALUE_TPEG_ILC_NAME_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TPEG_ILC_NAME_1,
            self::VALUE_TPEG_ILC_NAME_2,
            self::VALUE_TPEG_ILC_NAME_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
