<?php

namespace EnumType;

/**
 * This class stands for TicketingFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Ticketing Facility.
 * @subpackage Enumerations
 */
class TicketingFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'ticketMachines'
     * @return string 'ticketMachines'
     */
    const VALUE_TICKET_MACHINES = 'ticketMachines';
    /**
     * Constant for value 'ticketOffice'
     * @return string 'ticketOffice'
     */
    const VALUE_TICKET_OFFICE = 'ticketOffice';
    /**
     * Constant for value 'ticketOnDemandMachines'
     * @return string 'ticketOnDemandMachines'
     */
    const VALUE_TICKET_ON_DEMAND_MACHINES = 'ticketOnDemandMachines';
    /**
     * Constant for value 'ticketSales'
     * @return string 'ticketSales'
     */
    const VALUE_TICKET_SALES = 'ticketSales';
    /**
     * Constant for value 'mobileTicketing'
     * @return string 'mobileTicketing'
     */
    const VALUE_MOBILE_TICKETING = 'mobileTicketing';
    /**
     * Constant for value 'ticketCollection'
     * @return string 'ticketCollection'
     */
    const VALUE_TICKET_COLLECTION = 'ticketCollection';
    /**
     * Constant for value 'centralReservations'
     * @return string 'centralReservations'
     */
    const VALUE_CENTRAL_RESERVATIONS = 'centralReservations';
    /**
     * Constant for value 'localTickets'
     * @return string 'localTickets'
     */
    const VALUE_LOCAL_TICKETS = 'localTickets';
    /**
     * Constant for value 'nationalTickets'
     * @return string 'nationalTickets'
     */
    const VALUE_NATIONAL_TICKETS = 'nationalTickets';
    /**
     * Constant for value 'internationalTickets'
     * @return string 'internationalTickets'
     */
    const VALUE_INTERNATIONAL_TICKETS = 'internationalTickets';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_TICKET_MACHINES
     * @uses self::VALUE_TICKET_OFFICE
     * @uses self::VALUE_TICKET_ON_DEMAND_MACHINES
     * @uses self::VALUE_TICKET_SALES
     * @uses self::VALUE_MOBILE_TICKETING
     * @uses self::VALUE_TICKET_COLLECTION
     * @uses self::VALUE_CENTRAL_RESERVATIONS
     * @uses self::VALUE_LOCAL_TICKETS
     * @uses self::VALUE_NATIONAL_TICKETS
     * @uses self::VALUE_INTERNATIONAL_TICKETS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_TICKET_MACHINES,
            self::VALUE_TICKET_OFFICE,
            self::VALUE_TICKET_ON_DEMAND_MACHINES,
            self::VALUE_TICKET_SALES,
            self::VALUE_MOBILE_TICKETING,
            self::VALUE_TICKET_COLLECTION,
            self::VALUE_CENTRAL_RESERVATIONS,
            self::VALUE_LOCAL_TICKETS,
            self::VALUE_NATIONAL_TICKETS,
            self::VALUE_INTERNATIONAL_TICKETS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
