<?php

namespace EnumType;

/**
 * This class stands for SubscriptionStateEnum EnumType
 * @subpackage Enumerations
 */
class SubscriptionStateEnum
{
    /**
     * Constant for value 'active'
     * @return string 'active'
     */
    const VALUE_ACTIVE = 'active';
    /**
     * Constant for value 'suspended'
     * @return string 'suspended'
     */
    const VALUE_SUSPENDED = 'suspended';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_SUSPENDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_SUSPENDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
