<?php

namespace EnumType;

/**
 * This class stands for SubjectTypeOfWorksEnum EnumType
 * @subpackage Enumerations
 */
class SubjectTypeOfWorksEnum
{
    /**
     * Constant for value 'bridge'
     * @return string 'bridge'
     */
    const VALUE_BRIDGE = 'bridge';
    /**
     * Constant for value 'buriedCables'
     * @return string 'buriedCables'
     */
    const VALUE_BURIED_CABLES = 'buriedCables';
    /**
     * Constant for value 'buriedServices'
     * @return string 'buriedServices'
     */
    const VALUE_BURIED_SERVICES = 'buriedServices';
    /**
     * Constant for value 'crashBarrier'
     * @return string 'crashBarrier'
     */
    const VALUE_CRASH_BARRIER = 'crashBarrier';
    /**
     * Constant for value 'gallery'
     * @return string 'gallery'
     */
    const VALUE_GALLERY = 'gallery';
    /**
     * Constant for value 'gantry'
     * @return string 'gantry'
     */
    const VALUE_GANTRY = 'gantry';
    /**
     * Constant for value 'gasMainWork'
     * @return string 'gasMainWork'
     */
    const VALUE_GAS_MAIN_WORK = 'gasMainWork';
    /**
     * Constant for value 'interchange'
     * @return string 'interchange'
     */
    const VALUE_INTERCHANGE = 'interchange';
    /**
     * Constant for value 'junction'
     * @return string 'junction'
     */
    const VALUE_JUNCTION = 'junction';
    /**
     * Constant for value 'levelCrossing'
     * @return string 'levelCrossing'
     */
    const VALUE_LEVEL_CROSSING = 'levelCrossing';
    /**
     * Constant for value 'lightingSystem'
     * @return string 'lightingSystem'
     */
    const VALUE_LIGHTING_SYSTEM = 'lightingSystem';
    /**
     * Constant for value 'measurementEquipment'
     * @return string 'measurementEquipment'
     */
    const VALUE_MEASUREMENT_EQUIPMENT = 'measurementEquipment';
    /**
     * Constant for value 'noiseProtection'
     * @return string 'noiseProtection'
     */
    const VALUE_NOISE_PROTECTION = 'noiseProtection';
    /**
     * Constant for value 'road'
     * @return string 'road'
     */
    const VALUE_ROAD = 'road';
    /**
     * Constant for value 'roadsideDrains'
     * @return string 'roadsideDrains'
     */
    const VALUE_ROADSIDE_DRAINS = 'roadsideDrains';
    /**
     * Constant for value 'roadsideEmbankment'
     * @return string 'roadsideEmbankment'
     */
    const VALUE_ROADSIDE_EMBANKMENT = 'roadsideEmbankment';
    /**
     * Constant for value 'roadsideEquipment'
     * @return string 'roadsideEquipment'
     */
    const VALUE_ROADSIDE_EQUIPMENT = 'roadsideEquipment';
    /**
     * Constant for value 'roadSigns'
     * @return string 'roadSigns'
     */
    const VALUE_ROAD_SIGNS = 'roadSigns';
    /**
     * Constant for value 'roundabout'
     * @return string 'roundabout'
     */
    const VALUE_ROUNDABOUT = 'roundabout';
    /**
     * Constant for value 'tollGate'
     * @return string 'tollGate'
     */
    const VALUE_TOLL_GATE = 'tollGate';
    /**
     * Constant for value 'tunnel'
     * @return string 'tunnel'
     */
    const VALUE_TUNNEL = 'tunnel';
    /**
     * Constant for value 'waterMain'
     * @return string 'waterMain'
     */
    const VALUE_WATER_MAIN = 'waterMain';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BRIDGE
     * @uses self::VALUE_BURIED_CABLES
     * @uses self::VALUE_BURIED_SERVICES
     * @uses self::VALUE_CRASH_BARRIER
     * @uses self::VALUE_GALLERY
     * @uses self::VALUE_GANTRY
     * @uses self::VALUE_GAS_MAIN_WORK
     * @uses self::VALUE_INTERCHANGE
     * @uses self::VALUE_JUNCTION
     * @uses self::VALUE_LEVEL_CROSSING
     * @uses self::VALUE_LIGHTING_SYSTEM
     * @uses self::VALUE_MEASUREMENT_EQUIPMENT
     * @uses self::VALUE_NOISE_PROTECTION
     * @uses self::VALUE_ROAD
     * @uses self::VALUE_ROADSIDE_DRAINS
     * @uses self::VALUE_ROADSIDE_EMBANKMENT
     * @uses self::VALUE_ROADSIDE_EQUIPMENT
     * @uses self::VALUE_ROAD_SIGNS
     * @uses self::VALUE_ROUNDABOUT
     * @uses self::VALUE_TOLL_GATE
     * @uses self::VALUE_TUNNEL
     * @uses self::VALUE_WATER_MAIN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BRIDGE,
            self::VALUE_BURIED_CABLES,
            self::VALUE_BURIED_SERVICES,
            self::VALUE_CRASH_BARRIER,
            self::VALUE_GALLERY,
            self::VALUE_GANTRY,
            self::VALUE_GAS_MAIN_WORK,
            self::VALUE_INTERCHANGE,
            self::VALUE_JUNCTION,
            self::VALUE_LEVEL_CROSSING,
            self::VALUE_LIGHTING_SYSTEM,
            self::VALUE_MEASUREMENT_EQUIPMENT,
            self::VALUE_NOISE_PROTECTION,
            self::VALUE_ROAD,
            self::VALUE_ROADSIDE_DRAINS,
            self::VALUE_ROADSIDE_EMBANKMENT,
            self::VALUE_ROADSIDE_EQUIPMENT,
            self::VALUE_ROAD_SIGNS,
            self::VALUE_ROUNDABOUT,
            self::VALUE_TOLL_GATE,
            self::VALUE_TUNNEL,
            self::VALUE_WATER_MAIN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
