<?php

namespace EnumType;

/**
 * This class stands for StopPlaceComponentTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of SITE COMPONENT Types.
 * @subpackage Enumerations
 */
class StopPlaceComponentTypeEnumeration
{
    /**
     * Constant for value 'quay'
     * @return string 'quay'
     */
    const VALUE_QUAY = 'quay';
    /**
     * Constant for value 'accessSpace'
     * @return string 'accessSpace'
     */
    const VALUE_ACCESS_SPACE = 'accessSpace';
    /**
     * Constant for value 'entrance'
     * @return string 'entrance'
     */
    const VALUE_ENTRANCE = 'entrance';
    /**
     * Constant for value 'boardingPosition'
     * @return string 'boardingPosition'
     */
    const VALUE_BOARDING_POSITION = 'boardingPosition';
    /**
     * Constant for value 'stoppingPlace'
     * @return string 'stoppingPlace'
     */
    const VALUE_STOPPING_PLACE = 'stoppingPlace';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_QUAY
     * @uses self::VALUE_ACCESS_SPACE
     * @uses self::VALUE_ENTRANCE
     * @uses self::VALUE_BOARDING_POSITION
     * @uses self::VALUE_STOPPING_PLACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_QUAY,
            self::VALUE_ACCESS_SPACE,
            self::VALUE_ENTRANCE,
            self::VALUE_BOARDING_POSITION,
            self::VALUE_STOPPING_PLACE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
