<?php

namespace EnumType;

/**
 * This class stands for SelfDriveSubmodesOfTransportEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for SelfDrive ModesOfTransport: TPEG pti_table_12.
 * @subpackage Enumerations
 */
class SelfDriveSubmodesOfTransportEnumeration
{
    /**
     * Constant for value 'pti12_0'
     * @return string 'pti12_0'
     */
    const VALUE_PTI_12_0 = 'pti12_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti12_1'
     * @return string 'pti12_1'
     */
    const VALUE_PTI_12_1 = 'pti12_1';
    /**
     * Constant for value 'hireCar'
     * @return string 'hireCar'
     */
    const VALUE_HIRE_CAR = 'hireCar';
    /**
     * Constant for value 'pti12_2'
     * @return string 'pti12_2'
     */
    const VALUE_PTI_12_2 = 'pti12_2';
    /**
     * Constant for value 'hireVan'
     * @return string 'hireVan'
     */
    const VALUE_HIRE_VAN = 'hireVan';
    /**
     * Constant for value 'pti12_3'
     * @return string 'pti12_3'
     */
    const VALUE_PTI_12_3 = 'pti12_3';
    /**
     * Constant for value 'hireMotorbike'
     * @return string 'hireMotorbike'
     */
    const VALUE_HIRE_MOTORBIKE = 'hireMotorbike';
    /**
     * Constant for value 'pti12_4'
     * @return string 'pti12_4'
     */
    const VALUE_PTI_12_4 = 'pti12_4';
    /**
     * Constant for value 'hireCycle'
     * @return string 'hireCycle'
     */
    const VALUE_HIRE_CYCLE = 'hireCycle';
    /**
     * Constant for value 'pti12_5'
     * @return string 'pti12_5'
     */
    const VALUE_PTI_12_5 = 'pti12_5';
    /**
     * Constant for value 'allHireVehicles'
     * @return string 'allHireVehicles'
     */
    const VALUE_ALL_HIRE_VEHICLES = 'allHireVehicles';
    /**
     * Constant for value 'pti12_255'
     * @return string 'pti12_255'
     */
    const VALUE_PTI_12_255 = 'pti12_255';
    /**
     * Constant for value 'undefinedHireVehicle'
     * @return string 'undefinedHireVehicle'
     */
    const VALUE_UNDEFINED_HIRE_VEHICLE = 'undefinedHireVehicle';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_12_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_12_1
     * @uses self::VALUE_HIRE_CAR
     * @uses self::VALUE_PTI_12_2
     * @uses self::VALUE_HIRE_VAN
     * @uses self::VALUE_PTI_12_3
     * @uses self::VALUE_HIRE_MOTORBIKE
     * @uses self::VALUE_PTI_12_4
     * @uses self::VALUE_HIRE_CYCLE
     * @uses self::VALUE_PTI_12_5
     * @uses self::VALUE_ALL_HIRE_VEHICLES
     * @uses self::VALUE_PTI_12_255
     * @uses self::VALUE_UNDEFINED_HIRE_VEHICLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_12_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_12_1,
            self::VALUE_HIRE_CAR,
            self::VALUE_PTI_12_2,
            self::VALUE_HIRE_VAN,
            self::VALUE_PTI_12_3,
            self::VALUE_HIRE_MOTORBIKE,
            self::VALUE_PTI_12_4,
            self::VALUE_HIRE_CYCLE,
            self::VALUE_PTI_12_5,
            self::VALUE_ALL_HIRE_VEHICLES,
            self::VALUE_PTI_12_255,
            self::VALUE_UNDEFINED_HIRE_VEHICLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
