<?php

namespace EnumType;

/**
 * This class stands for SanitaryFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Sanitary Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class SanitaryFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti23_22'
     * @return string 'pti23_22'
     */
    const VALUE_PTI_23_22 = 'pti23_22';
    /**
     * Constant for value 'toilet'
     * @return string 'toilet'
     */
    const VALUE_TOILET = 'toilet';
    /**
     * Constant for value 'pti23_23'
     * @return string 'pti23_23'
     */
    const VALUE_PTI_23_23 = 'pti23_23';
    /**
     * Constant for value 'noToilet'
     * @return string 'noToilet'
     */
    const VALUE_NO_TOILET = 'noToilet';
    /**
     * Constant for value 'shower'
     * @return string 'shower'
     */
    const VALUE_SHOWER = 'shower';
    /**
     * Constant for value 'wheelchairAcccessToilet'
     * @return string 'wheelchairAcccessToilet'
     */
    const VALUE_WHEELCHAIR_ACCCESS_TOILET = 'wheelchairAcccessToilet';
    /**
     * Constant for value 'babyChange'
     * @return string 'babyChange'
     */
    const VALUE_BABY_CHANGE = 'babyChange';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_23_22
     * @uses self::VALUE_TOILET
     * @uses self::VALUE_PTI_23_23
     * @uses self::VALUE_NO_TOILET
     * @uses self::VALUE_SHOWER
     * @uses self::VALUE_WHEELCHAIR_ACCCESS_TOILET
     * @uses self::VALUE_BABY_CHANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_23_22,
            self::VALUE_TOILET,
            self::VALUE_PTI_23_23,
            self::VALUE_NO_TOILET,
            self::VALUE_SHOWER,
            self::VALUE_WHEELCHAIR_ACCCESS_TOILET,
            self::VALUE_BABY_CHANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
