<?php

namespace EnumType;

/**
 * This class stands for RoadworksDurationEnum EnumType
 * @subpackage Enumerations
 */
class RoadworksDurationEnum
{
    /**
     * Constant for value 'longTerm'
     * @return string 'longTerm'
     */
    const VALUE_LONG_TERM = 'longTerm';
    /**
     * Constant for value 'mediumTerm'
     * @return string 'mediumTerm'
     */
    const VALUE_MEDIUM_TERM = 'mediumTerm';
    /**
     * Constant for value 'shortTerm'
     * @return string 'shortTerm'
     */
    const VALUE_SHORT_TERM = 'shortTerm';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LONG_TERM
     * @uses self::VALUE_MEDIUM_TERM
     * @uses self::VALUE_SHORT_TERM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LONG_TERM,
            self::VALUE_MEDIUM_TERM,
            self::VALUE_SHORT_TERM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
