<?php

namespace EnumType;

/**
 * This class stands for RoadsideServiceDisruptionTypeEnum EnumType
 * @subpackage Enumerations
 */
class RoadsideServiceDisruptionTypeEnum
{
    /**
     * Constant for value 'barClosed'
     * @return string 'barClosed'
     */
    const VALUE_BAR_CLOSED = 'barClosed';
    /**
     * Constant for value 'dieselShortage'
     * @return string 'dieselShortage'
     */
    const VALUE_DIESEL_SHORTAGE = 'dieselShortage';
    /**
     * Constant for value 'fuelShortage'
     * @return string 'fuelShortage'
     */
    const VALUE_FUEL_SHORTAGE = 'fuelShortage';
    /**
     * Constant for value 'lpgShortage'
     * @return string 'lpgShortage'
     */
    const VALUE_LPG_SHORTAGE = 'lpgShortage';
    /**
     * Constant for value 'methaneShortage'
     * @return string 'methaneShortage'
     */
    const VALUE_METHANE_SHORTAGE = 'methaneShortage';
    /**
     * Constant for value 'noDieselForHeavyVehicles'
     * @return string 'noDieselForHeavyVehicles'
     */
    const VALUE_NO_DIESEL_FOR_HEAVY_VEHICLES = 'noDieselForHeavyVehicles';
    /**
     * Constant for value 'noDieselForLightVehicles'
     * @return string 'noDieselForLightVehicles'
     */
    const VALUE_NO_DIESEL_FOR_LIGHT_VEHICLES = 'noDieselForLightVehicles';
    /**
     * Constant for value 'noPublicTelephones'
     * @return string 'noPublicTelephones'
     */
    const VALUE_NO_PUBLIC_TELEPHONES = 'noPublicTelephones';
    /**
     * Constant for value 'noToiletFacilities'
     * @return string 'noToiletFacilities'
     */
    const VALUE_NO_TOILET_FACILITIES = 'noToiletFacilities';
    /**
     * Constant for value 'noVehicleRepairFacilities'
     * @return string 'noVehicleRepairFacilities'
     */
    const VALUE_NO_VEHICLE_REPAIR_FACILITIES = 'noVehicleRepairFacilities';
    /**
     * Constant for value 'petrolShortage'
     * @return string 'petrolShortage'
     */
    const VALUE_PETROL_SHORTAGE = 'petrolShortage';
    /**
     * Constant for value 'restAreaBusy'
     * @return string 'restAreaBusy'
     */
    const VALUE_REST_AREA_BUSY = 'restAreaBusy';
    /**
     * Constant for value 'restAreaClosed'
     * @return string 'restAreaClosed'
     */
    const VALUE_REST_AREA_CLOSED = 'restAreaClosed';
    /**
     * Constant for value 'restAreaOvercrowdedDriveToAnotherRestArea'
     * @return string 'restAreaOvercrowdedDriveToAnotherRestArea'
     */
    const VALUE_REST_AREA_OVERCROWDED_DRIVE_TO_ANOTHER_REST_AREA = 'restAreaOvercrowdedDriveToAnotherRestArea';
    /**
     * Constant for value 'serviceAreaBusy'
     * @return string 'serviceAreaBusy'
     */
    const VALUE_SERVICE_AREA_BUSY = 'serviceAreaBusy';
    /**
     * Constant for value 'serviceAreaClosed'
     * @return string 'serviceAreaClosed'
     */
    const VALUE_SERVICE_AREA_CLOSED = 'serviceAreaClosed';
    /**
     * Constant for value 'serviceAreaFuelStationClosed'
     * @return string 'serviceAreaFuelStationClosed'
     */
    const VALUE_SERVICE_AREA_FUEL_STATION_CLOSED = 'serviceAreaFuelStationClosed';
    /**
     * Constant for value 'serviceAreaOvercrowdedDriveToAnotherServiceArea'
     * @return string 'serviceAreaOvercrowdedDriveToAnotherServiceArea'
     */
    const VALUE_SERVICE_AREA_OVERCROWDED_DRIVE_TO_ANOTHER_SERVICE_AREA = 'serviceAreaOvercrowdedDriveToAnotherServiceArea';
    /**
     * Constant for value 'serviceAreaRestaurantClosed'
     * @return string 'serviceAreaRestaurantClosed'
     */
    const VALUE_SERVICE_AREA_RESTAURANT_CLOSED = 'serviceAreaRestaurantClosed';
    /**
     * Constant for value 'someCommercialServicesClosed'
     * @return string 'someCommercialServicesClosed'
     */
    const VALUE_SOME_COMMERCIAL_SERVICES_CLOSED = 'someCommercialServicesClosed';
    /**
     * Constant for value 'waterShortage'
     * @return string 'waterShortage'
     */
    const VALUE_WATER_SHORTAGE = 'waterShortage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BAR_CLOSED
     * @uses self::VALUE_DIESEL_SHORTAGE
     * @uses self::VALUE_FUEL_SHORTAGE
     * @uses self::VALUE_LPG_SHORTAGE
     * @uses self::VALUE_METHANE_SHORTAGE
     * @uses self::VALUE_NO_DIESEL_FOR_HEAVY_VEHICLES
     * @uses self::VALUE_NO_DIESEL_FOR_LIGHT_VEHICLES
     * @uses self::VALUE_NO_PUBLIC_TELEPHONES
     * @uses self::VALUE_NO_TOILET_FACILITIES
     * @uses self::VALUE_NO_VEHICLE_REPAIR_FACILITIES
     * @uses self::VALUE_PETROL_SHORTAGE
     * @uses self::VALUE_REST_AREA_BUSY
     * @uses self::VALUE_REST_AREA_CLOSED
     * @uses self::VALUE_REST_AREA_OVERCROWDED_DRIVE_TO_ANOTHER_REST_AREA
     * @uses self::VALUE_SERVICE_AREA_BUSY
     * @uses self::VALUE_SERVICE_AREA_CLOSED
     * @uses self::VALUE_SERVICE_AREA_FUEL_STATION_CLOSED
     * @uses self::VALUE_SERVICE_AREA_OVERCROWDED_DRIVE_TO_ANOTHER_SERVICE_AREA
     * @uses self::VALUE_SERVICE_AREA_RESTAURANT_CLOSED
     * @uses self::VALUE_SOME_COMMERCIAL_SERVICES_CLOSED
     * @uses self::VALUE_WATER_SHORTAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BAR_CLOSED,
            self::VALUE_DIESEL_SHORTAGE,
            self::VALUE_FUEL_SHORTAGE,
            self::VALUE_LPG_SHORTAGE,
            self::VALUE_METHANE_SHORTAGE,
            self::VALUE_NO_DIESEL_FOR_HEAVY_VEHICLES,
            self::VALUE_NO_DIESEL_FOR_LIGHT_VEHICLES,
            self::VALUE_NO_PUBLIC_TELEPHONES,
            self::VALUE_NO_TOILET_FACILITIES,
            self::VALUE_NO_VEHICLE_REPAIR_FACILITIES,
            self::VALUE_PETROL_SHORTAGE,
            self::VALUE_REST_AREA_BUSY,
            self::VALUE_REST_AREA_CLOSED,
            self::VALUE_REST_AREA_OVERCROWDED_DRIVE_TO_ANOTHER_REST_AREA,
            self::VALUE_SERVICE_AREA_BUSY,
            self::VALUE_SERVICE_AREA_CLOSED,
            self::VALUE_SERVICE_AREA_FUEL_STATION_CLOSED,
            self::VALUE_SERVICE_AREA_OVERCROWDED_DRIVE_TO_ANOTHER_SERVICE_AREA,
            self::VALUE_SERVICE_AREA_RESTAURANT_CLOSED,
            self::VALUE_SOME_COMMERCIAL_SERVICES_CLOSED,
            self::VALUE_WATER_SHORTAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
