<?php

namespace EnumType;

/**
 * This class stands for RoadsideAssistanceTypeEnum EnumType
 * @subpackage Enumerations
 */
class RoadsideAssistanceTypeEnum
{
    /**
     * Constant for value 'airAmbulance'
     * @return string 'airAmbulance'
     */
    const VALUE_AIR_AMBULANCE = 'airAmbulance';
    /**
     * Constant for value 'busPassengerAssistance'
     * @return string 'busPassengerAssistance'
     */
    const VALUE_BUS_PASSENGER_ASSISTANCE = 'busPassengerAssistance';
    /**
     * Constant for value 'emergencyServices'
     * @return string 'emergencyServices'
     */
    const VALUE_EMERGENCY_SERVICES = 'emergencyServices';
    /**
     * Constant for value 'firstAid'
     * @return string 'firstAid'
     */
    const VALUE_FIRST_AID = 'firstAid';
    /**
     * Constant for value 'foodDelivery'
     * @return string 'foodDelivery'
     */
    const VALUE_FOOD_DELIVERY = 'foodDelivery';
    /**
     * Constant for value 'helicopterRescue'
     * @return string 'helicopterRescue'
     */
    const VALUE_HELICOPTER_RESCUE = 'helicopterRescue';
    /**
     * Constant for value 'vehicleRepair'
     * @return string 'vehicleRepair'
     */
    const VALUE_VEHICLE_REPAIR = 'vehicleRepair';
    /**
     * Constant for value 'vehicleRecovery'
     * @return string 'vehicleRecovery'
     */
    const VALUE_VEHICLE_RECOVERY = 'vehicleRecovery';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIR_AMBULANCE
     * @uses self::VALUE_BUS_PASSENGER_ASSISTANCE
     * @uses self::VALUE_EMERGENCY_SERVICES
     * @uses self::VALUE_FIRST_AID
     * @uses self::VALUE_FOOD_DELIVERY
     * @uses self::VALUE_HELICOPTER_RESCUE
     * @uses self::VALUE_VEHICLE_REPAIR
     * @uses self::VALUE_VEHICLE_RECOVERY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIR_AMBULANCE,
            self::VALUE_BUS_PASSENGER_ASSISTANCE,
            self::VALUE_EMERGENCY_SERVICES,
            self::VALUE_FIRST_AID,
            self::VALUE_FOOD_DELIVERY,
            self::VALUE_HELICOPTER_RESCUE,
            self::VALUE_VEHICLE_REPAIR,
            self::VALUE_VEHICLE_RECOVERY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
