<?php

namespace EnumType;

/**
 * This class stands for RoadOrCarriagewayOrLaneManagementTypeEnum EnumType
 * @subpackage Enumerations
 */
class RoadOrCarriagewayOrLaneManagementTypeEnum
{
    /**
     * Constant for value 'carPoolLaneInOperation'
     * @return string 'carPoolLaneInOperation'
     */
    const VALUE_CAR_POOL_LANE_IN_OPERATION = 'carPoolLaneInOperation';
    /**
     * Constant for value 'carriagewayClosures'
     * @return string 'carriagewayClosures'
     */
    const VALUE_CARRIAGEWAY_CLOSURES = 'carriagewayClosures';
    /**
     * Constant for value 'clearALaneForEmergencyVehicles'
     * @return string 'clearALaneForEmergencyVehicles'
     */
    const VALUE_CLEAR_ALANE_FOR_EMERGENCY_VEHICLES = 'clearALaneForEmergencyVehicles';
    /**
     * Constant for value 'clearALaneForSnowploughsAndGrittingVehicles'
     * @return string 'clearALaneForSnowploughsAndGrittingVehicles'
     */
    const VALUE_CLEAR_ALANE_FOR_SNOWPLOUGHS_AND_GRITTING_VEHICLES = 'clearALaneForSnowploughsAndGrittingVehicles';
    /**
     * Constant for value 'closedPermanentlyForTheWinter'
     * @return string 'closedPermanentlyForTheWinter'
     */
    const VALUE_CLOSED_PERMANENTLY_FOR_THE_WINTER = 'closedPermanentlyForTheWinter';
    /**
     * Constant for value 'contraflow'
     * @return string 'contraflow'
     */
    const VALUE_CONTRAFLOW = 'contraflow';
    /**
     * Constant for value 'doNotUseSpecifiedLanesOrCarriageways'
     * @return string 'doNotUseSpecifiedLanesOrCarriageways'
     */
    const VALUE_DO_NOT_USE_SPECIFIED_LANES_OR_CARRIAGEWAYS = 'doNotUseSpecifiedLanesOrCarriageways';
    /**
     * Constant for value 'hardShoulderRunningInOperation'
     * @return string 'hardShoulderRunningInOperation'
     */
    const VALUE_HARD_SHOULDER_RUNNING_IN_OPERATION = 'hardShoulderRunningInOperation';
    /**
     * Constant for value 'intermittentShortTermClosures'
     * @return string 'intermittentShortTermClosures'
     */
    const VALUE_INTERMITTENT_SHORT_TERM_CLOSURES = 'intermittentShortTermClosures';
    /**
     * Constant for value 'keepToTheLeft'
     * @return string 'keepToTheLeft'
     */
    const VALUE_KEEP_TO_THE_LEFT = 'keepToTheLeft';
    /**
     * Constant for value 'keepToTheRight'
     * @return string 'keepToTheRight'
     */
    const VALUE_KEEP_TO_THE_RIGHT = 'keepToTheRight';
    /**
     * Constant for value 'laneClosures'
     * @return string 'laneClosures'
     */
    const VALUE_LANE_CLOSURES = 'laneClosures';
    /**
     * Constant for value 'lanesDeviated'
     * @return string 'lanesDeviated'
     */
    const VALUE_LANES_DEVIATED = 'lanesDeviated';
    /**
     * Constant for value 'narrowLanes'
     * @return string 'narrowLanes'
     */
    const VALUE_NARROW_LANES = 'narrowLanes';
    /**
     * Constant for value 'newRoadworksLayout'
     * @return string 'newRoadworksLayout'
     */
    const VALUE_NEW_ROADWORKS_LAYOUT = 'newRoadworksLayout';
    /**
     * Constant for value 'overnightClosures'
     * @return string 'overnightClosures'
     */
    const VALUE_OVERNIGHT_CLOSURES = 'overnightClosures';
    /**
     * Constant for value 'roadCleared'
     * @return string 'roadCleared'
     */
    const VALUE_ROAD_CLEARED = 'roadCleared';
    /**
     * Constant for value 'roadClosed'
     * @return string 'roadClosed'
     */
    const VALUE_ROAD_CLOSED = 'roadClosed';
    /**
     * Constant for value 'rollingRoadBlock'
     * @return string 'rollingRoadBlock'
     */
    const VALUE_ROLLING_ROAD_BLOCK = 'rollingRoadBlock';
    /**
     * Constant for value 'rushHourLaneInOperation'
     * @return string 'rushHourLaneInOperation'
     */
    const VALUE_RUSH_HOUR_LANE_IN_OPERATION = 'rushHourLaneInOperation';
    /**
     * Constant for value 'singleAlternateLineTraffic'
     * @return string 'singleAlternateLineTraffic'
     */
    const VALUE_SINGLE_ALTERNATE_LINE_TRAFFIC = 'singleAlternateLineTraffic';
    /**
     * Constant for value 'tidalFlowLaneInOperation'
     * @return string 'tidalFlowLaneInOperation'
     */
    const VALUE_TIDAL_FLOW_LANE_IN_OPERATION = 'tidalFlowLaneInOperation';
    /**
     * Constant for value 'turnAroundInOperation'
     * @return string 'turnAroundInOperation'
     */
    const VALUE_TURN_AROUND_IN_OPERATION = 'turnAroundInOperation';
    /**
     * Constant for value 'useOfSpecifiedLanesOrCarriagewaysAllowed'
     * @return string 'useOfSpecifiedLanesOrCarriagewaysAllowed'
     */
    const VALUE_USE_OF_SPECIFIED_LANES_OR_CARRIAGEWAYS_ALLOWED = 'useOfSpecifiedLanesOrCarriagewaysAllowed';
    /**
     * Constant for value 'useSpecifiedLanesOrCarriageways'
     * @return string 'useSpecifiedLanesOrCarriageways'
     */
    const VALUE_USE_SPECIFIED_LANES_OR_CARRIAGEWAYS = 'useSpecifiedLanesOrCarriageways';
    /**
     * Constant for value 'vehicleStorageInOperation'
     * @return string 'vehicleStorageInOperation'
     */
    const VALUE_VEHICLE_STORAGE_IN_OPERATION = 'vehicleStorageInOperation';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAR_POOL_LANE_IN_OPERATION
     * @uses self::VALUE_CARRIAGEWAY_CLOSURES
     * @uses self::VALUE_CLEAR_ALANE_FOR_EMERGENCY_VEHICLES
     * @uses self::VALUE_CLEAR_ALANE_FOR_SNOWPLOUGHS_AND_GRITTING_VEHICLES
     * @uses self::VALUE_CLOSED_PERMANENTLY_FOR_THE_WINTER
     * @uses self::VALUE_CONTRAFLOW
     * @uses self::VALUE_DO_NOT_USE_SPECIFIED_LANES_OR_CARRIAGEWAYS
     * @uses self::VALUE_HARD_SHOULDER_RUNNING_IN_OPERATION
     * @uses self::VALUE_INTERMITTENT_SHORT_TERM_CLOSURES
     * @uses self::VALUE_KEEP_TO_THE_LEFT
     * @uses self::VALUE_KEEP_TO_THE_RIGHT
     * @uses self::VALUE_LANE_CLOSURES
     * @uses self::VALUE_LANES_DEVIATED
     * @uses self::VALUE_NARROW_LANES
     * @uses self::VALUE_NEW_ROADWORKS_LAYOUT
     * @uses self::VALUE_OVERNIGHT_CLOSURES
     * @uses self::VALUE_ROAD_CLEARED
     * @uses self::VALUE_ROAD_CLOSED
     * @uses self::VALUE_ROLLING_ROAD_BLOCK
     * @uses self::VALUE_RUSH_HOUR_LANE_IN_OPERATION
     * @uses self::VALUE_SINGLE_ALTERNATE_LINE_TRAFFIC
     * @uses self::VALUE_TIDAL_FLOW_LANE_IN_OPERATION
     * @uses self::VALUE_TURN_AROUND_IN_OPERATION
     * @uses self::VALUE_USE_OF_SPECIFIED_LANES_OR_CARRIAGEWAYS_ALLOWED
     * @uses self::VALUE_USE_SPECIFIED_LANES_OR_CARRIAGEWAYS
     * @uses self::VALUE_VEHICLE_STORAGE_IN_OPERATION
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAR_POOL_LANE_IN_OPERATION,
            self::VALUE_CARRIAGEWAY_CLOSURES,
            self::VALUE_CLEAR_ALANE_FOR_EMERGENCY_VEHICLES,
            self::VALUE_CLEAR_ALANE_FOR_SNOWPLOUGHS_AND_GRITTING_VEHICLES,
            self::VALUE_CLOSED_PERMANENTLY_FOR_THE_WINTER,
            self::VALUE_CONTRAFLOW,
            self::VALUE_DO_NOT_USE_SPECIFIED_LANES_OR_CARRIAGEWAYS,
            self::VALUE_HARD_SHOULDER_RUNNING_IN_OPERATION,
            self::VALUE_INTERMITTENT_SHORT_TERM_CLOSURES,
            self::VALUE_KEEP_TO_THE_LEFT,
            self::VALUE_KEEP_TO_THE_RIGHT,
            self::VALUE_LANE_CLOSURES,
            self::VALUE_LANES_DEVIATED,
            self::VALUE_NARROW_LANES,
            self::VALUE_NEW_ROADWORKS_LAYOUT,
            self::VALUE_OVERNIGHT_CLOSURES,
            self::VALUE_ROAD_CLEARED,
            self::VALUE_ROAD_CLOSED,
            self::VALUE_ROLLING_ROAD_BLOCK,
            self::VALUE_RUSH_HOUR_LANE_IN_OPERATION,
            self::VALUE_SINGLE_ALTERNATE_LINE_TRAFFIC,
            self::VALUE_TIDAL_FLOW_LANE_IN_OPERATION,
            self::VALUE_TURN_AROUND_IN_OPERATION,
            self::VALUE_USE_OF_SPECIFIED_LANES_OR_CARRIAGEWAYS_ALLOWED,
            self::VALUE_USE_SPECIFIED_LANES_OR_CARRIAGEWAYS,
            self::VALUE_VEHICLE_STORAGE_IN_OPERATION,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
