<?php

namespace EnumType;

/**
 * This class stands for RoadOperatorServiceDisruptionTypeEnum EnumType
 * @subpackage Enumerations
 */
class RoadOperatorServiceDisruptionTypeEnum
{
    /**
     * Constant for value 'emergencyTelephoneNumberOutOfService'
     * @return string 'emergencyTelephoneNumberOutOfService'
     */
    const VALUE_EMERGENCY_TELEPHONE_NUMBER_OUT_OF_SERVICE = 'emergencyTelephoneNumberOutOfService';
    /**
     * Constant for value 'informationServiceTelephoneNumberOutOfService'
     * @return string 'informationServiceTelephoneNumberOutOfService'
     */
    const VALUE_INFORMATION_SERVICE_TELEPHONE_NUMBER_OUT_OF_SERVICE = 'informationServiceTelephoneNumberOutOfService';
    /**
     * Constant for value 'noTrafficOfficerPatrolService'
     * @return string 'noTrafficOfficerPatrolService'
     */
    const VALUE_NO_TRAFFIC_OFFICER_PATROL_SERVICE = 'noTrafficOfficerPatrolService';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMERGENCY_TELEPHONE_NUMBER_OUT_OF_SERVICE
     * @uses self::VALUE_INFORMATION_SERVICE_TELEPHONE_NUMBER_OUT_OF_SERVICE
     * @uses self::VALUE_NO_TRAFFIC_OFFICER_PATROL_SERVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMERGENCY_TELEPHONE_NUMBER_OUT_OF_SERVICE,
            self::VALUE_INFORMATION_SERVICE_TELEPHONE_NUMBER_OUT_OF_SERVICE,
            self::VALUE_NO_TRAFFIC_OFFICER_PATROL_SERVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
