<?php

namespace EnumType;

/**
 * This class stands for ReservedSpaceFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Reserved Space Facility.
 * @subpackage Enumerations
 */
class ReservedSpaceFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'lounge'
     * @return string 'lounge'
     */
    const VALUE_LOUNGE = 'lounge';
    /**
     * Constant for value 'hall'
     * @return string 'hall'
     */
    const VALUE_HALL = 'hall';
    /**
     * Constant for value 'meetingpoint'
     * @return string 'meetingpoint'
     */
    const VALUE_MEETINGPOINT = 'meetingpoint';
    /**
     * Constant for value 'groupPoint'
     * @return string 'groupPoint'
     */
    const VALUE_GROUP_POINT = 'groupPoint';
    /**
     * Constant for value 'reception'
     * @return string 'reception'
     */
    const VALUE_RECEPTION = 'reception';
    /**
     * Constant for value 'shelter'
     * @return string 'shelter'
     */
    const VALUE_SHELTER = 'shelter';
    /**
     * Constant for value 'seats'
     * @return string 'seats'
     */
    const VALUE_SEATS = 'seats';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_LOUNGE
     * @uses self::VALUE_HALL
     * @uses self::VALUE_MEETINGPOINT
     * @uses self::VALUE_GROUP_POINT
     * @uses self::VALUE_RECEPTION
     * @uses self::VALUE_SHELTER
     * @uses self::VALUE_SEATS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_LOUNGE,
            self::VALUE_HALL,
            self::VALUE_MEETINGPOINT,
            self::VALUE_GROUP_POINT,
            self::VALUE_RECEPTION,
            self::VALUE_SHELTER,
            self::VALUE_SEATS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
