<?php

namespace EnumType;

/**
 * This class stands for ReroutingManagementTypeEnum EnumType
 * @subpackage Enumerations
 */
class ReroutingManagementTypeEnum
{
    /**
     * Constant for value 'doNotFollowDiversionSigns'
     * @return string 'doNotFollowDiversionSigns'
     */
    const VALUE_DO_NOT_FOLLOW_DIVERSION_SIGNS = 'doNotFollowDiversionSigns';
    /**
     * Constant for value 'doNotUseEntry'
     * @return string 'doNotUseEntry'
     */
    const VALUE_DO_NOT_USE_ENTRY = 'doNotUseEntry';
    /**
     * Constant for value 'doNotUseExit'
     * @return string 'doNotUseExit'
     */
    const VALUE_DO_NOT_USE_EXIT = 'doNotUseExit';
    /**
     * Constant for value 'doNotUseIntersectionOrJunction'
     * @return string 'doNotUseIntersectionOrJunction'
     */
    const VALUE_DO_NOT_USE_INTERSECTION_OR_JUNCTION = 'doNotUseIntersectionOrJunction';
    /**
     * Constant for value 'followDiversionSigns'
     * @return string 'followDiversionSigns'
     */
    const VALUE_FOLLOW_DIVERSION_SIGNS = 'followDiversionSigns';
    /**
     * Constant for value 'followLocalDiversion'
     * @return string 'followLocalDiversion'
     */
    const VALUE_FOLLOW_LOCAL_DIVERSION = 'followLocalDiversion';
    /**
     * Constant for value 'followSpecialMarkers'
     * @return string 'followSpecialMarkers'
     */
    const VALUE_FOLLOW_SPECIAL_MARKERS = 'followSpecialMarkers';
    /**
     * Constant for value 'useEntry'
     * @return string 'useEntry'
     */
    const VALUE_USE_ENTRY = 'useEntry';
    /**
     * Constant for value 'useExit'
     * @return string 'useExit'
     */
    const VALUE_USE_EXIT = 'useExit';
    /**
     * Constant for value 'useIntersectionOrJunction'
     * @return string 'useIntersectionOrJunction'
     */
    const VALUE_USE_INTERSECTION_OR_JUNCTION = 'useIntersectionOrJunction';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DO_NOT_FOLLOW_DIVERSION_SIGNS
     * @uses self::VALUE_DO_NOT_USE_ENTRY
     * @uses self::VALUE_DO_NOT_USE_EXIT
     * @uses self::VALUE_DO_NOT_USE_INTERSECTION_OR_JUNCTION
     * @uses self::VALUE_FOLLOW_DIVERSION_SIGNS
     * @uses self::VALUE_FOLLOW_LOCAL_DIVERSION
     * @uses self::VALUE_FOLLOW_SPECIAL_MARKERS
     * @uses self::VALUE_USE_ENTRY
     * @uses self::VALUE_USE_EXIT
     * @uses self::VALUE_USE_INTERSECTION_OR_JUNCTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DO_NOT_FOLLOW_DIVERSION_SIGNS,
            self::VALUE_DO_NOT_USE_ENTRY,
            self::VALUE_DO_NOT_USE_EXIT,
            self::VALUE_DO_NOT_USE_INTERSECTION_OR_JUNCTION,
            self::VALUE_FOLLOW_DIVERSION_SIGNS,
            self::VALUE_FOLLOW_LOCAL_DIVERSION,
            self::VALUE_FOLLOW_SPECIAL_MARKERS,
            self::VALUE_USE_ENTRY,
            self::VALUE_USE_EXIT,
            self::VALUE_USE_INTERSECTION_OR_JUNCTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
