<?php

namespace EnumType;

/**
 * This class stands for RemedyTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for actions to remedy a faclity change.
 * @subpackage Enumerations
 */
class RemedyTypeEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'replace'
     * @return string 'replace'
     */
    const VALUE_REPLACE = 'replace';
    /**
     * Constant for value 'repair'
     * @return string 'repair'
     */
    const VALUE_REPAIR = 'repair';
    /**
     * Constant for value 'remove'
     * @return string 'remove'
     */
    const VALUE_REMOVE = 'remove';
    /**
     * Constant for value 'otherRoute'
     * @return string 'otherRoute'
     */
    const VALUE_OTHER_ROUTE = 'otherRoute';
    /**
     * Constant for value 'otherLocation'
     * @return string 'otherLocation'
     */
    const VALUE_OTHER_LOCATION = 'otherLocation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_REPLACE
     * @uses self::VALUE_REPAIR
     * @uses self::VALUE_REMOVE
     * @uses self::VALUE_OTHER_ROUTE
     * @uses self::VALUE_OTHER_LOCATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_REPLACE,
            self::VALUE_REPAIR,
            self::VALUE_REMOVE,
            self::VALUE_OTHER_ROUTE,
            self::VALUE_OTHER_LOCATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
