<?php

namespace EnumType;

/**
 * This class stands for QualityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Quality of data indication.
 * @subpackage Enumerations
 */
class QualityEnumeration
{
    /**
     * Constant for value 'certain'
     * @return string 'certain'
     */
    const VALUE_CERTAIN = 'certain';
    /**
     * Constant for value 'veryReliable'
     * @return string 'veryReliable'
     */
    const VALUE_VERY_RELIABLE = 'veryReliable';
    /**
     * Constant for value 'reliable'
     * @return string 'reliable'
     */
    const VALUE_RELIABLE = 'reliable';
    /**
     * Constant for value 'probablyReliable'
     * @return string 'probablyReliable'
     */
    const VALUE_PROBABLY_RELIABLE = 'probablyReliable';
    /**
     * Constant for value 'unconfirmed'
     * @return string 'unconfirmed'
     */
    const VALUE_UNCONFIRMED = 'unconfirmed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERTAIN
     * @uses self::VALUE_VERY_RELIABLE
     * @uses self::VALUE_RELIABLE
     * @uses self::VALUE_PROBABLY_RELIABLE
     * @uses self::VALUE_UNCONFIRMED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTAIN,
            self::VALUE_VERY_RELIABLE,
            self::VALUE_RELIABLE,
            self::VALUE_PROBABLY_RELIABLE,
            self::VALUE_UNCONFIRMED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
