<?php

namespace EnumType;

/**
 * This class stands for PyschosensoryNeedEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of specific psychosensory USER NEEDs.
 * @subpackage Enumerations
 */
class PyschosensoryNeedEnumeration
{
    /**
     * Constant for value 'visualImpairment'
     * @return string 'visualImpairment'
     */
    const VALUE_VISUAL_IMPAIRMENT = 'visualImpairment';
    /**
     * Constant for value 'auditoryImpairment'
     * @return string 'auditoryImpairment'
     */
    const VALUE_AUDITORY_IMPAIRMENT = 'auditoryImpairment';
    /**
     * Constant for value 'cognitiveInputImpairment'
     * @return string 'cognitiveInputImpairment'
     */
    const VALUE_COGNITIVE_INPUT_IMPAIRMENT = 'cognitiveInputImpairment';
    /**
     * Constant for value 'averseToLifts'
     * @return string 'averseToLifts'
     */
    const VALUE_AVERSE_TO_LIFTS = 'averseToLifts';
    /**
     * Constant for value 'averseToEscalators'
     * @return string 'averseToEscalators'
     */
    const VALUE_AVERSE_TO_ESCALATORS = 'averseToEscalators';
    /**
     * Constant for value 'averseToConfinedSpaces'
     * @return string 'averseToConfinedSpaces'
     */
    const VALUE_AVERSE_TO_CONFINED_SPACES = 'averseToConfinedSpaces';
    /**
     * Constant for value 'averseToCrowds'
     * @return string 'averseToCrowds'
     */
    const VALUE_AVERSE_TO_CROWDS = 'averseToCrowds';
    /**
     * Constant for value 'otherPsychosensoryNeed'
     * @return string 'otherPsychosensoryNeed'
     */
    const VALUE_OTHER_PSYCHOSENSORY_NEED = 'otherPsychosensoryNeed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VISUAL_IMPAIRMENT
     * @uses self::VALUE_AUDITORY_IMPAIRMENT
     * @uses self::VALUE_COGNITIVE_INPUT_IMPAIRMENT
     * @uses self::VALUE_AVERSE_TO_LIFTS
     * @uses self::VALUE_AVERSE_TO_ESCALATORS
     * @uses self::VALUE_AVERSE_TO_CONFINED_SPACES
     * @uses self::VALUE_AVERSE_TO_CROWDS
     * @uses self::VALUE_OTHER_PSYCHOSENSORY_NEED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VISUAL_IMPAIRMENT,
            self::VALUE_AUDITORY_IMPAIRMENT,
            self::VALUE_COGNITIVE_INPUT_IMPAIRMENT,
            self::VALUE_AVERSE_TO_LIFTS,
            self::VALUE_AVERSE_TO_ESCALATORS,
            self::VALUE_AVERSE_TO_CONFINED_SPACES,
            self::VALUE_AVERSE_TO_CROWDS,
            self::VALUE_OTHER_PSYCHOSENSORY_NEED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
