<?php

namespace EnumType;

/**
 * This class stands for PublicEventTypeEnum EnumType
 * @subpackage Enumerations
 */
class PublicEventTypeEnum
{
    /**
     * Constant for value 'agriculturalShow'
     * @return string 'agriculturalShow'
     */
    const VALUE_AGRICULTURAL_SHOW = 'agriculturalShow';
    /**
     * Constant for value 'airShow'
     * @return string 'airShow'
     */
    const VALUE_AIR_SHOW = 'airShow';
    /**
     * Constant for value 'athleticsMeeting'
     * @return string 'athleticsMeeting'
     */
    const VALUE_ATHLETICS_MEETING = 'athleticsMeeting';
    /**
     * Constant for value 'commercialEvent'
     * @return string 'commercialEvent'
     */
    const VALUE_COMMERCIAL_EVENT = 'commercialEvent';
    /**
     * Constant for value 'culturalEvent'
     * @return string 'culturalEvent'
     */
    const VALUE_CULTURAL_EVENT = 'culturalEvent';
    /**
     * Constant for value 'ballGame'
     * @return string 'ballGame'
     */
    const VALUE_BALL_GAME = 'ballGame';
    /**
     * Constant for value 'baseballGame'
     * @return string 'baseballGame'
     */
    const VALUE_BASEBALL_GAME = 'baseballGame';
    /**
     * Constant for value 'basketballGame'
     * @return string 'basketballGame'
     */
    const VALUE_BASKETBALL_GAME = 'basketballGame';
    /**
     * Constant for value 'bicycleRace'
     * @return string 'bicycleRace'
     */
    const VALUE_BICYCLE_RACE = 'bicycleRace';
    /**
     * Constant for value 'boatRace'
     * @return string 'boatRace'
     */
    const VALUE_BOAT_RACE = 'boatRace';
    /**
     * Constant for value 'boatShow'
     * @return string 'boatShow'
     */
    const VALUE_BOAT_SHOW = 'boatShow';
    /**
     * Constant for value 'boxingTournament'
     * @return string 'boxingTournament'
     */
    const VALUE_BOXING_TOURNAMENT = 'boxingTournament';
    /**
     * Constant for value 'bullFight'
     * @return string 'bullFight'
     */
    const VALUE_BULL_FIGHT = 'bullFight';
    /**
     * Constant for value 'ceremonialEvent'
     * @return string 'ceremonialEvent'
     */
    const VALUE_CEREMONIAL_EVENT = 'ceremonialEvent';
    /**
     * Constant for value 'concert'
     * @return string 'concert'
     */
    const VALUE_CONCERT = 'concert';
    /**
     * Constant for value 'cricketMatch'
     * @return string 'cricketMatch'
     */
    const VALUE_CRICKET_MATCH = 'cricketMatch';
    /**
     * Constant for value 'exhibition'
     * @return string 'exhibition'
     */
    const VALUE_EXHIBITION = 'exhibition';
    /**
     * Constant for value 'fair'
     * @return string 'fair'
     */
    const VALUE_FAIR = 'fair';
    /**
     * Constant for value 'festival'
     * @return string 'festival'
     */
    const VALUE_FESTIVAL = 'festival';
    /**
     * Constant for value 'filmTVMaking'
     * @return string 'filmTVMaking'
     */
    const VALUE_FILM_TVMAKING = 'filmTVMaking';
    /**
     * Constant for value 'footballMatch'
     * @return string 'footballMatch'
     */
    const VALUE_FOOTBALL_MATCH = 'footballMatch';
    /**
     * Constant for value 'funfair'
     * @return string 'funfair'
     */
    const VALUE_FUNFAIR = 'funfair';
    /**
     * Constant for value 'gardeningOrFlowerShow'
     * @return string 'gardeningOrFlowerShow'
     */
    const VALUE_GARDENING_OR_FLOWER_SHOW = 'gardeningOrFlowerShow';
    /**
     * Constant for value 'golfTournament'
     * @return string 'golfTournament'
     */
    const VALUE_GOLF_TOURNAMENT = 'golfTournament';
    /**
     * Constant for value 'hockeyGame'
     * @return string 'hockeyGame'
     */
    const VALUE_HOCKEY_GAME = 'hockeyGame';
    /**
     * Constant for value 'horseRaceMeeting'
     * @return string 'horseRaceMeeting'
     */
    const VALUE_HORSE_RACE_MEETING = 'horseRaceMeeting';
    /**
     * Constant for value 'internationalSportsMeeting'
     * @return string 'internationalSportsMeeting'
     */
    const VALUE_INTERNATIONAL_SPORTS_MEETING = 'internationalSportsMeeting';
    /**
     * Constant for value 'majorEvent'
     * @return string 'majorEvent'
     */
    const VALUE_MAJOR_EVENT = 'majorEvent';
    /**
     * Constant for value 'marathon'
     * @return string 'marathon'
     */
    const VALUE_MARATHON = 'marathon';
    /**
     * Constant for value 'market'
     * @return string 'market'
     */
    const VALUE_MARKET = 'market';
    /**
     * Constant for value 'match'
     * @return string 'match'
     */
    const VALUE_MATCH = 'match';
    /**
     * Constant for value 'motorShow'
     * @return string 'motorShow'
     */
    const VALUE_MOTOR_SHOW = 'motorShow';
    /**
     * Constant for value 'motorSportRaceMeeting'
     * @return string 'motorSportRaceMeeting'
     */
    const VALUE_MOTOR_SPORT_RACE_MEETING = 'motorSportRaceMeeting';
    /**
     * Constant for value 'parade'
     * @return string 'parade'
     */
    const VALUE_PARADE = 'parade';
    /**
     * Constant for value 'procession'
     * @return string 'procession'
     */
    const VALUE_PROCESSION = 'procession';
    /**
     * Constant for value 'raceMeeting'
     * @return string 'raceMeeting'
     */
    const VALUE_RACE_MEETING = 'raceMeeting';
    /**
     * Constant for value 'rugbyMatch'
     * @return string 'rugbyMatch'
     */
    const VALUE_RUGBY_MATCH = 'rugbyMatch';
    /**
     * Constant for value 'severalMajorEvents'
     * @return string 'severalMajorEvents'
     */
    const VALUE_SEVERAL_MAJOR_EVENTS = 'severalMajorEvents';
    /**
     * Constant for value 'show'
     * @return string 'show'
     */
    const VALUE_SHOW = 'show';
    /**
     * Constant for value 'showJumping'
     * @return string 'showJumping'
     */
    const VALUE_SHOW_JUMPING = 'showJumping';
    /**
     * Constant for value 'sportsMeeting'
     * @return string 'sportsMeeting'
     */
    const VALUE_SPORTS_MEETING = 'sportsMeeting';
    /**
     * Constant for value 'stateOccasion'
     * @return string 'stateOccasion'
     */
    const VALUE_STATE_OCCASION = 'stateOccasion';
    /**
     * Constant for value 'tennisTournament'
     * @return string 'tennisTournament'
     */
    const VALUE_TENNIS_TOURNAMENT = 'tennisTournament';
    /**
     * Constant for value 'tournament'
     * @return string 'tournament'
     */
    const VALUE_TOURNAMENT = 'tournament';
    /**
     * Constant for value 'tradeFair'
     * @return string 'tradeFair'
     */
    const VALUE_TRADE_FAIR = 'tradeFair';
    /**
     * Constant for value 'waterSportsMeeting'
     * @return string 'waterSportsMeeting'
     */
    const VALUE_WATER_SPORTS_MEETING = 'waterSportsMeeting';
    /**
     * Constant for value 'winterSportsMeeting'
     * @return string 'winterSportsMeeting'
     */
    const VALUE_WINTER_SPORTS_MEETING = 'winterSportsMeeting';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AGRICULTURAL_SHOW
     * @uses self::VALUE_AIR_SHOW
     * @uses self::VALUE_ATHLETICS_MEETING
     * @uses self::VALUE_COMMERCIAL_EVENT
     * @uses self::VALUE_CULTURAL_EVENT
     * @uses self::VALUE_BALL_GAME
     * @uses self::VALUE_BASEBALL_GAME
     * @uses self::VALUE_BASKETBALL_GAME
     * @uses self::VALUE_BICYCLE_RACE
     * @uses self::VALUE_BOAT_RACE
     * @uses self::VALUE_BOAT_SHOW
     * @uses self::VALUE_BOXING_TOURNAMENT
     * @uses self::VALUE_BULL_FIGHT
     * @uses self::VALUE_CEREMONIAL_EVENT
     * @uses self::VALUE_CONCERT
     * @uses self::VALUE_CRICKET_MATCH
     * @uses self::VALUE_EXHIBITION
     * @uses self::VALUE_FAIR
     * @uses self::VALUE_FESTIVAL
     * @uses self::VALUE_FILM_TVMAKING
     * @uses self::VALUE_FOOTBALL_MATCH
     * @uses self::VALUE_FUNFAIR
     * @uses self::VALUE_GARDENING_OR_FLOWER_SHOW
     * @uses self::VALUE_GOLF_TOURNAMENT
     * @uses self::VALUE_HOCKEY_GAME
     * @uses self::VALUE_HORSE_RACE_MEETING
     * @uses self::VALUE_INTERNATIONAL_SPORTS_MEETING
     * @uses self::VALUE_MAJOR_EVENT
     * @uses self::VALUE_MARATHON
     * @uses self::VALUE_MARKET
     * @uses self::VALUE_MATCH
     * @uses self::VALUE_MOTOR_SHOW
     * @uses self::VALUE_MOTOR_SPORT_RACE_MEETING
     * @uses self::VALUE_PARADE
     * @uses self::VALUE_PROCESSION
     * @uses self::VALUE_RACE_MEETING
     * @uses self::VALUE_RUGBY_MATCH
     * @uses self::VALUE_SEVERAL_MAJOR_EVENTS
     * @uses self::VALUE_SHOW
     * @uses self::VALUE_SHOW_JUMPING
     * @uses self::VALUE_SPORTS_MEETING
     * @uses self::VALUE_STATE_OCCASION
     * @uses self::VALUE_TENNIS_TOURNAMENT
     * @uses self::VALUE_TOURNAMENT
     * @uses self::VALUE_TRADE_FAIR
     * @uses self::VALUE_WATER_SPORTS_MEETING
     * @uses self::VALUE_WINTER_SPORTS_MEETING
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AGRICULTURAL_SHOW,
            self::VALUE_AIR_SHOW,
            self::VALUE_ATHLETICS_MEETING,
            self::VALUE_COMMERCIAL_EVENT,
            self::VALUE_CULTURAL_EVENT,
            self::VALUE_BALL_GAME,
            self::VALUE_BASEBALL_GAME,
            self::VALUE_BASKETBALL_GAME,
            self::VALUE_BICYCLE_RACE,
            self::VALUE_BOAT_RACE,
            self::VALUE_BOAT_SHOW,
            self::VALUE_BOXING_TOURNAMENT,
            self::VALUE_BULL_FIGHT,
            self::VALUE_CEREMONIAL_EVENT,
            self::VALUE_CONCERT,
            self::VALUE_CRICKET_MATCH,
            self::VALUE_EXHIBITION,
            self::VALUE_FAIR,
            self::VALUE_FESTIVAL,
            self::VALUE_FILM_TVMAKING,
            self::VALUE_FOOTBALL_MATCH,
            self::VALUE_FUNFAIR,
            self::VALUE_GARDENING_OR_FLOWER_SHOW,
            self::VALUE_GOLF_TOURNAMENT,
            self::VALUE_HOCKEY_GAME,
            self::VALUE_HORSE_RACE_MEETING,
            self::VALUE_INTERNATIONAL_SPORTS_MEETING,
            self::VALUE_MAJOR_EVENT,
            self::VALUE_MARATHON,
            self::VALUE_MARKET,
            self::VALUE_MATCH,
            self::VALUE_MOTOR_SHOW,
            self::VALUE_MOTOR_SPORT_RACE_MEETING,
            self::VALUE_PARADE,
            self::VALUE_PROCESSION,
            self::VALUE_RACE_MEETING,
            self::VALUE_RUGBY_MATCH,
            self::VALUE_SEVERAL_MAJOR_EVENTS,
            self::VALUE_SHOW,
            self::VALUE_SHOW_JUMPING,
            self::VALUE_SPORTS_MEETING,
            self::VALUE_STATE_OCCASION,
            self::VALUE_TENNIS_TOURNAMENT,
            self::VALUE_TOURNAMENT,
            self::VALUE_TRADE_FAIR,
            self::VALUE_WATER_SPORTS_MEETING,
            self::VALUE_WINTER_SPORTS_MEETING,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
