<?php

namespace EnumType;

/**
 * This class stands for ProbabilityOfOccurrenceEnum EnumType
 * @subpackage Enumerations
 */
class ProbabilityOfOccurrenceEnum
{
    /**
     * Constant for value 'certain'
     * @return string 'certain'
     */
    const VALUE_CERTAIN = 'certain';
    /**
     * Constant for value 'probable'
     * @return string 'probable'
     */
    const VALUE_PROBABLE = 'probable';
    /**
     * Constant for value 'riskOf'
     * @return string 'riskOf'
     */
    const VALUE_RISK_OF = 'riskOf';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERTAIN
     * @uses self::VALUE_PROBABLE
     * @uses self::VALUE_RISK_OF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTAIN,
            self::VALUE_PROBABLE,
            self::VALUE_RISK_OF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
