<?php

namespace EnumType;

/**
 * This class stands for PathHeadingEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for path heading.
 * @subpackage Enumerations
 */
class PathHeadingEnumeration
{
    /**
     * Constant for value 'left'
     * @return string 'left'
     */
    const VALUE_LEFT = 'left';
    /**
     * Constant for value 'right'
     * @return string 'right'
     */
    const VALUE_RIGHT = 'right';
    /**
     * Constant for value 'forward'
     * @return string 'forward'
     */
    const VALUE_FORWARD = 'forward';
    /**
     * Constant for value 'back'
     * @return string 'back'
     */
    const VALUE_BACK = 'back';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LEFT
     * @uses self::VALUE_RIGHT
     * @uses self::VALUE_FORWARD
     * @uses self::VALUE_BACK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEFT,
            self::VALUE_RIGHT,
            self::VALUE_FORWARD,
            self::VALUE_BACK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
