<?php

namespace EnumType;

/**
 * This class stands for PathDirectionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for flow DIRECTION along PATH LINk.
 * @subpackage Enumerations
 */
class PathDirectionEnumeration
{
    /**
     * Constant for value 'oneWay'
     * @return string 'oneWay'
     */
    const VALUE_ONE_WAY = 'oneWay';
    /**
     * Constant for value 'twoWay'
     * @return string 'twoWay'
     */
    const VALUE_TWO_WAY = 'twoWay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONE_WAY
     * @uses self::VALUE_TWO_WAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONE_WAY,
            self::VALUE_TWO_WAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
