<?php

namespace EnumType;

/**
 * This class stands for PassengerInformationFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Passenger Information Facility.
 * @subpackage Enumerations
 */
class PassengerInformationFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'nextStopIndicator'
     * @return string 'nextStopIndicator'
     */
    const VALUE_NEXT_STOP_INDICATOR = 'nextStopIndicator';
    /**
     * Constant for value 'stopAnnouncements'
     * @return string 'stopAnnouncements'
     */
    const VALUE_STOP_ANNOUNCEMENTS = 'stopAnnouncements';
    /**
     * Constant for value 'passengerInformationDisplay'
     * @return string 'passengerInformationDisplay'
     */
    const VALUE_PASSENGER_INFORMATION_DISPLAY = 'passengerInformationDisplay';
    /**
     * Constant for value 'audioInformation'
     * @return string 'audioInformation'
     */
    const VALUE_AUDIO_INFORMATION = 'audioInformation';
    /**
     * Constant for value 'visualInformation'
     * @return string 'visualInformation'
     */
    const VALUE_VISUAL_INFORMATION = 'visualInformation';
    /**
     * Constant for value 'tactilePlatformEdges'
     * @return string 'tactilePlatformEdges'
     */
    const VALUE_TACTILE_PLATFORM_EDGES = 'tactilePlatformEdges';
    /**
     * Constant for value 'tactileInformation'
     * @return string 'tactileInformation'
     */
    const VALUE_TACTILE_INFORMATION = 'tactileInformation';
    /**
     * Constant for value 'walkingGuidance'
     * @return string 'walkingGuidance'
     */
    const VALUE_WALKING_GUIDANCE = 'walkingGuidance';
    /**
     * Constant for value 'journeyPlanning'
     * @return string 'journeyPlanning'
     */
    const VALUE_JOURNEY_PLANNING = 'journeyPlanning';
    /**
     * Constant for value 'lostFound'
     * @return string 'lostFound'
     */
    const VALUE_LOST_FOUND = 'lostFound';
    /**
     * Constant for value 'informationDesk'
     * @return string 'informationDesk'
     */
    const VALUE_INFORMATION_DESK = 'informationDesk';
    /**
     * Constant for value 'interactiveKiosk-Display'
     * @return string 'interactiveKiosk-Display'
     */
    const VALUE_INTERACTIVE_KIOSK_DISPLAY = 'interactiveKiosk-Display';
    /**
     * Constant for value 'printedPublicNotice'
     * @return string 'printedPublicNotice'
     */
    const VALUE_PRINTED_PUBLIC_NOTICE = 'printedPublicNotice';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_NEXT_STOP_INDICATOR
     * @uses self::VALUE_STOP_ANNOUNCEMENTS
     * @uses self::VALUE_PASSENGER_INFORMATION_DISPLAY
     * @uses self::VALUE_AUDIO_INFORMATION
     * @uses self::VALUE_VISUAL_INFORMATION
     * @uses self::VALUE_TACTILE_PLATFORM_EDGES
     * @uses self::VALUE_TACTILE_INFORMATION
     * @uses self::VALUE_WALKING_GUIDANCE
     * @uses self::VALUE_JOURNEY_PLANNING
     * @uses self::VALUE_LOST_FOUND
     * @uses self::VALUE_INFORMATION_DESK
     * @uses self::VALUE_INTERACTIVE_KIOSK_DISPLAY
     * @uses self::VALUE_PRINTED_PUBLIC_NOTICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_NEXT_STOP_INDICATOR,
            self::VALUE_STOP_ANNOUNCEMENTS,
            self::VALUE_PASSENGER_INFORMATION_DISPLAY,
            self::VALUE_AUDIO_INFORMATION,
            self::VALUE_VISUAL_INFORMATION,
            self::VALUE_TACTILE_PLATFORM_EDGES,
            self::VALUE_TACTILE_INFORMATION,
            self::VALUE_WALKING_GUIDANCE,
            self::VALUE_JOURNEY_PLANNING,
            self::VALUE_LOST_FOUND,
            self::VALUE_INFORMATION_DESK,
            self::VALUE_INTERACTIVE_KIOSK_DISPLAY,
            self::VALUE_PRINTED_PUBLIC_NOTICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
