<?php

namespace EnumType;

/**
 * This class stands for OverallSeverityEnum EnumType
 * @subpackage Enumerations
 */
class OverallSeverityEnum
{
    /**
     * Constant for value 'highest'
     * @return string 'highest'
     */
    const VALUE_HIGHEST = 'highest';
    /**
     * Constant for value 'high'
     * @return string 'high'
     */
    const VALUE_HIGH = 'high';
    /**
     * Constant for value 'medium'
     * @return string 'medium'
     */
    const VALUE_MEDIUM = 'medium';
    /**
     * Constant for value 'low'
     * @return string 'low'
     */
    const VALUE_LOW = 'low';
    /**
     * Constant for value 'lowest'
     * @return string 'lowest'
     */
    const VALUE_LOWEST = 'lowest';
    /**
     * Constant for value 'none'
     * @return string 'none'
     */
    const VALUE_NONE = 'none';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HIGHEST
     * @uses self::VALUE_HIGH
     * @uses self::VALUE_MEDIUM
     * @uses self::VALUE_LOW
     * @uses self::VALUE_LOWEST
     * @uses self::VALUE_NONE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HIGHEST,
            self::VALUE_HIGH,
            self::VALUE_MEDIUM,
            self::VALUE_LOW,
            self::VALUE_LOWEST,
            self::VALUE_NONE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
