<?php

namespace EnumType;

/**
 * This class stands for OperatorActionStatusEnum EnumType
 * @subpackage Enumerations
 */
class OperatorActionStatusEnum
{
    /**
     * Constant for value 'requested'
     * @return string 'requested'
     */
    const VALUE_REQUESTED = 'requested';
    /**
     * Constant for value 'approved'
     * @return string 'approved'
     */
    const VALUE_APPROVED = 'approved';
    /**
     * Constant for value 'beingImplemented'
     * @return string 'beingImplemented'
     */
    const VALUE_BEING_IMPLEMENTED = 'beingImplemented';
    /**
     * Constant for value 'implemented'
     * @return string 'implemented'
     */
    const VALUE_IMPLEMENTED = 'implemented';
    /**
     * Constant for value 'rejected'
     * @return string 'rejected'
     */
    const VALUE_REJECTED = 'rejected';
    /**
     * Constant for value 'terminationRequested'
     * @return string 'terminationRequested'
     */
    const VALUE_TERMINATION_REQUESTED = 'terminationRequested';
    /**
     * Constant for value 'beingTerminated'
     * @return string 'beingTerminated'
     */
    const VALUE_BEING_TERMINATED = 'beingTerminated';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REQUESTED
     * @uses self::VALUE_APPROVED
     * @uses self::VALUE_BEING_IMPLEMENTED
     * @uses self::VALUE_IMPLEMENTED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_TERMINATION_REQUESTED
     * @uses self::VALUE_BEING_TERMINATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REQUESTED,
            self::VALUE_APPROVED,
            self::VALUE_BEING_IMPLEMENTED,
            self::VALUE_IMPLEMENTED,
            self::VALUE_REJECTED,
            self::VALUE_TERMINATION_REQUESTED,
            self::VALUE_BEING_TERMINATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
