<?php

namespace EnumType;

/**
 * This class stands for OperatorActionOriginEnum EnumType
 * @subpackage Enumerations
 */
class OperatorActionOriginEnum
{
    /**
     * Constant for value 'external'
     * @return string 'external'
     */
    const VALUE_EXTERNAL = 'external';
    /**
     * Constant for value 'internal'
     * @return string 'internal'
     */
    const VALUE_INTERNAL = 'internal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXTERNAL
     * @uses self::VALUE_INTERNAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXTERNAL,
            self::VALUE_INTERNAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
