<?php

namespace EnumType;

/**
 * This class stands for NavigationTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for NAVIGATION PATH. type.
 * @subpackage Enumerations
 */
class NavigationTypeEnumeration
{
    /**
     * Constant for value 'hallToQuay'
     * @return string 'hallToQuay'
     */
    const VALUE_HALL_TO_QUAY = 'hallToQuay';
    /**
     * Constant for value 'hallToStreet'
     * @return string 'hallToStreet'
     */
    const VALUE_HALL_TO_STREET = 'hallToStreet';
    /**
     * Constant for value 'quayToHall'
     * @return string 'quayToHall'
     */
    const VALUE_QUAY_TO_HALL = 'quayToHall';
    /**
     * Constant for value 'quayToQuay'
     * @return string 'quayToQuay'
     */
    const VALUE_QUAY_TO_QUAY = 'quayToQuay';
    /**
     * Constant for value 'quayToStreet'
     * @return string 'quayToStreet'
     */
    const VALUE_QUAY_TO_STREET = 'quayToStreet';
    /**
     * Constant for value 'streetToHall'
     * @return string 'streetToHall'
     */
    const VALUE_STREET_TO_HALL = 'streetToHall';
    /**
     * Constant for value 'streetToQuay'
     * @return string 'streetToQuay'
     */
    const VALUE_STREET_TO_QUAY = 'streetToQuay';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HALL_TO_QUAY
     * @uses self::VALUE_HALL_TO_STREET
     * @uses self::VALUE_QUAY_TO_HALL
     * @uses self::VALUE_QUAY_TO_QUAY
     * @uses self::VALUE_QUAY_TO_STREET
     * @uses self::VALUE_STREET_TO_HALL
     * @uses self::VALUE_STREET_TO_QUAY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HALL_TO_QUAY,
            self::VALUE_HALL_TO_STREET,
            self::VALUE_QUAY_TO_HALL,
            self::VALUE_QUAY_TO_QUAY,
            self::VALUE_QUAY_TO_STREET,
            self::VALUE_STREET_TO_HALL,
            self::VALUE_STREET_TO_QUAY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
