<?php

namespace EnumType;

/**
 * This class stands for NatureEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Quality of data indication.
 * @subpackage Enumerations
 */
class NatureEnumeration
{
    /**
     * Constant for value 'plannedOnly'
     * @return string 'plannedOnly'
     */
    const VALUE_PLANNED_ONLY = 'plannedOnly';
    /**
     * Constant for value 'unplannedOnly'
     * @return string 'unplannedOnly'
     */
    const VALUE_UNPLANNED_ONLY = 'unplannedOnly';
    /**
     * Constant for value 'both'
     * @return string 'both'
     */
    const VALUE_BOTH = 'both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PLANNED_ONLY
     * @uses self::VALUE_UNPLANNED_ONLY
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLANNED_ONLY,
            self::VALUE_UNPLANNED_ONLY,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
