<?php

namespace EnumType;

/**
 * This class stands for MonitoringTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for the types of monitoring: automatic or manual - describing the hardware transducer (video, GPS/Radio, in-road sensors, etc.) doesn't seeme useful for SIRi.
 * @subpackage Enumerations
 */
class MonitoringTypeEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'manual'
     * @return string 'manual'
     */
    const VALUE_MANUAL = 'manual';
    /**
     * Constant for value 'automatic'
     * @return string 'automatic'
     */
    const VALUE_AUTOMATIC = 'automatic';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_MANUAL
     * @uses self::VALUE_AUTOMATIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_MANUAL,
            self::VALUE_AUTOMATIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
