<?php

namespace EnumType;

/**
 * This class stands for MedicalNeedEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of specific Medical USER NEEDs.
 * @subpackage Enumerations
 */
class MedicalNeedEnumeration
{
    /**
     * Constant for value 'allergic'
     * @return string 'allergic'
     */
    const VALUE_ALLERGIC = 'allergic';
    /**
     * Constant for value 'heartCondition'
     * @return string 'heartCondition'
     */
    const VALUE_HEART_CONDITION = 'heartCondition';
    /**
     * Constant for value 'otherMedicalNeed'
     * @return string 'otherMedicalNeed'
     */
    const VALUE_OTHER_MEDICAL_NEED = 'otherMedicalNeed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALLERGIC
     * @uses self::VALUE_HEART_CONDITION
     * @uses self::VALUE_OTHER_MEDICAL_NEED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLERGIC,
            self::VALUE_HEART_CONDITION,
            self::VALUE_OTHER_MEDICAL_NEED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
