<?php

namespace EnumType;

/**
 * This class stands for MaintenanceVehicleActionsEnum EnumType
 * @subpackage Enumerations
 */
class MaintenanceVehicleActionsEnum
{
    /**
     * Constant for value 'maintenanceVehiclesMergingIntoTrafficFlow'
     * @return string 'maintenanceVehiclesMergingIntoTrafficFlow'
     */
    const VALUE_MAINTENANCE_VEHICLES_MERGING_INTO_TRAFFIC_FLOW = 'maintenanceVehiclesMergingIntoTrafficFlow';
    /**
     * Constant for value 'saltAndGritSpreading'
     * @return string 'saltAndGritSpreading'
     */
    const VALUE_SALT_AND_GRIT_SPREADING = 'saltAndGritSpreading';
    /**
     * Constant for value 'slowMoving'
     * @return string 'slowMoving'
     */
    const VALUE_SLOW_MOVING = 'slowMoving';
    /**
     * Constant for value 'snowClearing'
     * @return string 'snowClearing'
     */
    const VALUE_SNOW_CLEARING = 'snowClearing';
    /**
     * Constant for value 'stoppingToServiceEquipments'
     * @return string 'stoppingToServiceEquipments'
     */
    const VALUE_STOPPING_TO_SERVICE_EQUIPMENTS = 'stoppingToServiceEquipments';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAINTENANCE_VEHICLES_MERGING_INTO_TRAFFIC_FLOW
     * @uses self::VALUE_SALT_AND_GRIT_SPREADING
     * @uses self::VALUE_SLOW_MOVING
     * @uses self::VALUE_SNOW_CLEARING
     * @uses self::VALUE_STOPPING_TO_SERVICE_EQUIPMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAINTENANCE_VEHICLES_MERGING_INTO_TRAFFIC_FLOW,
            self::VALUE_SALT_AND_GRIT_SPREADING,
            self::VALUE_SLOW_MOVING,
            self::VALUE_SNOW_CLEARING,
            self::VALUE_STOPPING_TO_SERVICE_EQUIPMENTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
