<?php

namespace EnumType;

/**
 * This class stands for LuggageFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Luggage Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class LuggageFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti23_17'
     * @return string 'pti23_17'
     */
    const VALUE_PTI_23_17 = 'pti23_17';
    /**
     * Constant for value 'bikeCarriage'
     * @return string 'bikeCarriage'
     */
    const VALUE_BIKE_CARRIAGE = 'bikeCarriage';
    /**
     * Constant for value 'baggageStorage'
     * @return string 'baggageStorage'
     */
    const VALUE_BAGGAGE_STORAGE = 'baggageStorage';
    /**
     * Constant for value 'leftLuggage'
     * @return string 'leftLuggage'
     */
    const VALUE_LEFT_LUGGAGE = 'leftLuggage';
    /**
     * Constant for value 'porterage'
     * @return string 'porterage'
     */
    const VALUE_PORTERAGE = 'porterage';
    /**
     * Constant for value 'baggageTrolleys'
     * @return string 'baggageTrolleys'
     */
    const VALUE_BAGGAGE_TROLLEYS = 'baggageTrolleys';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_23_17
     * @uses self::VALUE_BIKE_CARRIAGE
     * @uses self::VALUE_BAGGAGE_STORAGE
     * @uses self::VALUE_LEFT_LUGGAGE
     * @uses self::VALUE_PORTERAGE
     * @uses self::VALUE_BAGGAGE_TROLLEYS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_23_17,
            self::VALUE_BIKE_CARRIAGE,
            self::VALUE_BAGGAGE_STORAGE,
            self::VALUE_LEFT_LUGGAGE,
            self::VALUE_PORTERAGE,
            self::VALUE_BAGGAGE_TROLLEYS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
