<?php

namespace EnumType;

/**
 * This class stands for LocationDescriptorEnum EnumType
 * @subpackage Enumerations
 */
class LocationDescriptorEnum
{
    /**
     * Constant for value 'aroundABendInRoad'
     * @return string 'aroundABendInRoad'
     */
    const VALUE_AROUND_ABEND_IN_ROAD = 'aroundABendInRoad';
    /**
     * Constant for value 'atMotorwayInterchange'
     * @return string 'atMotorwayInterchange'
     */
    const VALUE_AT_MOTORWAY_INTERCHANGE = 'atMotorwayInterchange';
    /**
     * Constant for value 'atRestArea'
     * @return string 'atRestArea'
     */
    const VALUE_AT_REST_AREA = 'atRestArea';
    /**
     * Constant for value 'atServiceArea'
     * @return string 'atServiceArea'
     */
    const VALUE_AT_SERVICE_AREA = 'atServiceArea';
    /**
     * Constant for value 'atTollPlaza'
     * @return string 'atTollPlaza'
     */
    const VALUE_AT_TOLL_PLAZA = 'atTollPlaza';
    /**
     * Constant for value 'atTunnelEntryOrExit'
     * @return string 'atTunnelEntryOrExit'
     */
    const VALUE_AT_TUNNEL_ENTRY_OR_EXIT = 'atTunnelEntryOrExit';
    /**
     * Constant for value 'inbound'
     * @return string 'inbound'
     */
    const VALUE_INBOUND = 'inbound';
    /**
     * Constant for value 'inGallery'
     * @return string 'inGallery'
     */
    const VALUE_IN_GALLERY = 'inGallery';
    /**
     * Constant for value 'inTheCentre'
     * @return string 'inTheCentre'
     */
    const VALUE_IN_THE_CENTRE = 'inTheCentre';
    /**
     * Constant for value 'inTheOppositeDirection'
     * @return string 'inTheOppositeDirection'
     */
    const VALUE_IN_THE_OPPOSITE_DIRECTION = 'inTheOppositeDirection';
    /**
     * Constant for value 'inTunnel'
     * @return string 'inTunnel'
     */
    const VALUE_IN_TUNNEL = 'inTunnel';
    /**
     * Constant for value 'onBorder'
     * @return string 'onBorder'
     */
    const VALUE_ON_BORDER = 'onBorder';
    /**
     * Constant for value 'onBridge'
     * @return string 'onBridge'
     */
    const VALUE_ON_BRIDGE = 'onBridge';
    /**
     * Constant for value 'onConnector'
     * @return string 'onConnector'
     */
    const VALUE_ON_CONNECTOR = 'onConnector';
    /**
     * Constant for value 'onElevatedSection'
     * @return string 'onElevatedSection'
     */
    const VALUE_ON_ELEVATED_SECTION = 'onElevatedSection';
    /**
     * Constant for value 'onFlyover'
     * @return string 'onFlyover'
     */
    const VALUE_ON_FLYOVER = 'onFlyover';
    /**
     * Constant for value 'onIceRoad'
     * @return string 'onIceRoad'
     */
    const VALUE_ON_ICE_ROAD = 'onIceRoad';
    /**
     * Constant for value 'onLevelCrossing'
     * @return string 'onLevelCrossing'
     */
    const VALUE_ON_LEVEL_CROSSING = 'onLevelCrossing';
    /**
     * Constant for value 'onLinkRoad'
     * @return string 'onLinkRoad'
     */
    const VALUE_ON_LINK_ROAD = 'onLinkRoad';
    /**
     * Constant for value 'onPass'
     * @return string 'onPass'
     */
    const VALUE_ON_PASS = 'onPass';
    /**
     * Constant for value 'onRoundabout'
     * @return string 'onRoundabout'
     */
    const VALUE_ON_ROUNDABOUT = 'onRoundabout';
    /**
     * Constant for value 'onTheLeft'
     * @return string 'onTheLeft'
     */
    const VALUE_ON_THE_LEFT = 'onTheLeft';
    /**
     * Constant for value 'onTheRight'
     * @return string 'onTheRight'
     */
    const VALUE_ON_THE_RIGHT = 'onTheRight';
    /**
     * Constant for value 'onTheRoadway'
     * @return string 'onTheRoadway'
     */
    const VALUE_ON_THE_ROADWAY = 'onTheRoadway';
    /**
     * Constant for value 'onUndergroundSection'
     * @return string 'onUndergroundSection'
     */
    const VALUE_ON_UNDERGROUND_SECTION = 'onUndergroundSection';
    /**
     * Constant for value 'onUnderpass'
     * @return string 'onUnderpass'
     */
    const VALUE_ON_UNDERPASS = 'onUnderpass';
    /**
     * Constant for value 'outbound'
     * @return string 'outbound'
     */
    const VALUE_OUTBOUND = 'outbound';
    /**
     * Constant for value 'overCrestOfHill'
     * @return string 'overCrestOfHill'
     */
    const VALUE_OVER_CREST_OF_HILL = 'overCrestOfHill';
    /**
     * Constant for value 'withinJunction'
     * @return string 'withinJunction'
     */
    const VALUE_WITHIN_JUNCTION = 'withinJunction';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AROUND_ABEND_IN_ROAD
     * @uses self::VALUE_AT_MOTORWAY_INTERCHANGE
     * @uses self::VALUE_AT_REST_AREA
     * @uses self::VALUE_AT_SERVICE_AREA
     * @uses self::VALUE_AT_TOLL_PLAZA
     * @uses self::VALUE_AT_TUNNEL_ENTRY_OR_EXIT
     * @uses self::VALUE_INBOUND
     * @uses self::VALUE_IN_GALLERY
     * @uses self::VALUE_IN_THE_CENTRE
     * @uses self::VALUE_IN_THE_OPPOSITE_DIRECTION
     * @uses self::VALUE_IN_TUNNEL
     * @uses self::VALUE_ON_BORDER
     * @uses self::VALUE_ON_BRIDGE
     * @uses self::VALUE_ON_CONNECTOR
     * @uses self::VALUE_ON_ELEVATED_SECTION
     * @uses self::VALUE_ON_FLYOVER
     * @uses self::VALUE_ON_ICE_ROAD
     * @uses self::VALUE_ON_LEVEL_CROSSING
     * @uses self::VALUE_ON_LINK_ROAD
     * @uses self::VALUE_ON_PASS
     * @uses self::VALUE_ON_ROUNDABOUT
     * @uses self::VALUE_ON_THE_LEFT
     * @uses self::VALUE_ON_THE_RIGHT
     * @uses self::VALUE_ON_THE_ROADWAY
     * @uses self::VALUE_ON_UNDERGROUND_SECTION
     * @uses self::VALUE_ON_UNDERPASS
     * @uses self::VALUE_OUTBOUND
     * @uses self::VALUE_OVER_CREST_OF_HILL
     * @uses self::VALUE_WITHIN_JUNCTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AROUND_ABEND_IN_ROAD,
            self::VALUE_AT_MOTORWAY_INTERCHANGE,
            self::VALUE_AT_REST_AREA,
            self::VALUE_AT_SERVICE_AREA,
            self::VALUE_AT_TOLL_PLAZA,
            self::VALUE_AT_TUNNEL_ENTRY_OR_EXIT,
            self::VALUE_INBOUND,
            self::VALUE_IN_GALLERY,
            self::VALUE_IN_THE_CENTRE,
            self::VALUE_IN_THE_OPPOSITE_DIRECTION,
            self::VALUE_IN_TUNNEL,
            self::VALUE_ON_BORDER,
            self::VALUE_ON_BRIDGE,
            self::VALUE_ON_CONNECTOR,
            self::VALUE_ON_ELEVATED_SECTION,
            self::VALUE_ON_FLYOVER,
            self::VALUE_ON_ICE_ROAD,
            self::VALUE_ON_LEVEL_CROSSING,
            self::VALUE_ON_LINK_ROAD,
            self::VALUE_ON_PASS,
            self::VALUE_ON_ROUNDABOUT,
            self::VALUE_ON_THE_LEFT,
            self::VALUE_ON_THE_RIGHT,
            self::VALUE_ON_THE_ROADWAY,
            self::VALUE_ON_UNDERGROUND_SECTION,
            self::VALUE_ON_UNDERPASS,
            self::VALUE_OUTBOUND,
            self::VALUE_OVER_CREST_OF_HILL,
            self::VALUE_WITHIN_JUNCTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
