<?php

namespace EnumType;

/**
 * This class stands for InterchangeStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Interchange Status TPEG cross reference pti_table 31.
 * @subpackage Enumerations
 */
class InterchangeStatusEnumeration
{
    /**
     * Constant for value 'pti31_0'
     * @return string 'pti31_0'
     */
    const VALUE_PTI_31_0 = 'pti31_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti31_1'
     * @return string 'pti31_1'
     */
    const VALUE_PTI_31_1 = 'pti31_1';
    /**
     * Constant for value 'connection'
     * @return string 'connection'
     */
    const VALUE_CONNECTION = 'connection';
    /**
     * Constant for value 'pti31_2'
     * @return string 'pti31_2'
     */
    const VALUE_PTI_31_2 = 'pti31_2';
    /**
     * Constant for value 'replacement'
     * @return string 'replacement'
     */
    const VALUE_REPLACEMENT = 'replacement';
    /**
     * Constant for value 'pti31_3'
     * @return string 'pti31_3'
     */
    const VALUE_PTI_31_3 = 'pti31_3';
    /**
     * Constant for value 'alternative'
     * @return string 'alternative'
     */
    const VALUE_ALTERNATIVE = 'alternative';
    /**
     * Constant for value 'pti31_4'
     * @return string 'pti31_4'
     */
    const VALUE_PTI_31_4 = 'pti31_4';
    /**
     * Constant for value 'connectionNotHeld'
     * @return string 'connectionNotHeld'
     */
    const VALUE_CONNECTION_NOT_HELD = 'connectionNotHeld';
    /**
     * Constant for value 'pti31_5'
     * @return string 'pti31_5'
     */
    const VALUE_PTI_31_5 = 'pti31_5';
    /**
     * Constant for value 'connectionHeld'
     * @return string 'connectionHeld'
     */
    const VALUE_CONNECTION_HELD = 'connectionHeld';
    /**
     * Constant for value 'pti31_6'
     * @return string 'pti31_6'
     */
    const VALUE_PTI_31_6 = 'pti31_6';
    /**
     * Constant for value 'statusOfConenctionUndecided'
     * @return string 'statusOfConenctionUndecided'
     */
    const VALUE_STATUS_OF_CONENCTION_UNDECIDED = 'statusOfConenctionUndecided';
    /**
     * Constant for value 'pti31_255'
     * @return string 'pti31_255'
     */
    const VALUE_PTI_31_255 = 'pti31_255';
    /**
     * Constant for value 'undefinedCrossReferenceInformation'
     * @return string 'undefinedCrossReferenceInformation'
     */
    const VALUE_UNDEFINED_CROSS_REFERENCE_INFORMATION = 'undefinedCrossReferenceInformation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_31_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_31_1
     * @uses self::VALUE_CONNECTION
     * @uses self::VALUE_PTI_31_2
     * @uses self::VALUE_REPLACEMENT
     * @uses self::VALUE_PTI_31_3
     * @uses self::VALUE_ALTERNATIVE
     * @uses self::VALUE_PTI_31_4
     * @uses self::VALUE_CONNECTION_NOT_HELD
     * @uses self::VALUE_PTI_31_5
     * @uses self::VALUE_CONNECTION_HELD
     * @uses self::VALUE_PTI_31_6
     * @uses self::VALUE_STATUS_OF_CONENCTION_UNDECIDED
     * @uses self::VALUE_PTI_31_255
     * @uses self::VALUE_UNDEFINED_CROSS_REFERENCE_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_31_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_31_1,
            self::VALUE_CONNECTION,
            self::VALUE_PTI_31_2,
            self::VALUE_REPLACEMENT,
            self::VALUE_PTI_31_3,
            self::VALUE_ALTERNATIVE,
            self::VALUE_PTI_31_4,
            self::VALUE_CONNECTION_NOT_HELD,
            self::VALUE_PTI_31_5,
            self::VALUE_CONNECTION_HELD,
            self::VALUE_PTI_31_6,
            self::VALUE_STATUS_OF_CONENCTION_UNDECIDED,
            self::VALUE_PTI_31_255,
            self::VALUE_UNDEFINED_CROSS_REFERENCE_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
