<?php

namespace EnumType;

/**
 * This class stands for InterchangeManagementEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Nature of Interchange management.
 * @subpackage Enumerations
 */
class InterchangeManagementEnumeration
{
    /**
     * Constant for value 'Planned'
     * @return string 'Planned'
     */
    const VALUE_PLANNED = 'Planned';
    /**
     * Constant for value 'Advertised'
     * @return string 'Advertised'
     */
    const VALUE_ADVERTISED = 'Advertised';
    /**
     * Constant for value 'Controlled'
     * @return string 'Controlled'
     */
    const VALUE_CONTROLLED = 'Controlled';
    /**
     * Constant for value 'Guaranteed'
     * @return string 'Guaranteed'
     */
    const VALUE_GUARANTEED = 'Guaranteed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PLANNED
     * @uses self::VALUE_ADVERTISED
     * @uses self::VALUE_CONTROLLED
     * @uses self::VALUE_GUARANTEED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLANNED,
            self::VALUE_ADVERTISED,
            self::VALUE_CONTROLLED,
            self::VALUE_GUARANTEED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
