<?php

namespace EnumType;

/**
 * This class stands for InformationStatusEnum EnumType
 * @subpackage Enumerations
 */
class InformationStatusEnum
{
    /**
     * Constant for value 'real'
     * @return string 'real'
     */
    const VALUE_REAL = 'real';
    /**
     * Constant for value 'securityExercise'
     * @return string 'securityExercise'
     */
    const VALUE_SECURITY_EXERCISE = 'securityExercise';
    /**
     * Constant for value 'technicalExercise'
     * @return string 'technicalExercise'
     */
    const VALUE_TECHNICAL_EXERCISE = 'technicalExercise';
    /**
     * Constant for value 'test'
     * @return string 'test'
     */
    const VALUE_TEST = 'test';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REAL
     * @uses self::VALUE_SECURITY_EXERCISE
     * @uses self::VALUE_TECHNICAL_EXERCISE
     * @uses self::VALUE_TEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REAL,
            self::VALUE_SECURITY_EXERCISE,
            self::VALUE_TECHNICAL_EXERCISE,
            self::VALUE_TEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
