<?php

namespace EnumType;

/**
 * This class stands for ImageContentEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for image content.
 * @subpackage Enumerations
 */
class ImageContentEnumeration
{
    /**
     * Constant for value 'map'
     * @return string 'map'
     */
    const VALUE_MAP = 'map';
    /**
     * Constant for value 'graphic'
     * @return string 'graphic'
     */
    const VALUE_GRAPHIC = 'graphic';
    /**
     * Constant for value 'logo'
     * @return string 'logo'
     */
    const VALUE_LOGO = 'logo';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAP
     * @uses self::VALUE_GRAPHIC
     * @uses self::VALUE_LOGO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAP,
            self::VALUE_GRAPHIC,
            self::VALUE_LOGO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
